/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.client;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class OptimizedBeeModelLoader
implements IGeometryLoader<BeeGeometry> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"complicated_bees", (String)"optimized_bee_model");

    public BeeGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        return new BeeGeometry((UnbakedModel)deserializationContext.deserialize(jsonObject.get("base_model"), BlockModel.class));
    }

    static class BeeGeometry
    implements IUnbakedGeometry<BeeGeometry> {
        private final UnbakedModel model;

        BeeGeometry(UnbakedModel model) {
            this.model = model;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel bakedModel = this.model.m_7611_(baker, spriteGetter, modelState, modelLocation);
            return new BeeOverrideModel(bakedModel);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.model.m_5500_(modelGetter);
        }
    }

    private static class BeeOverrideList
    extends ItemOverrides {
        public static final IdentityHashMap<ResourceLocation, Variant> cacheMap = new IdentityHashMap();

        @Nullable
        public BakedModel m_173464_(BakedModel bakedModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            ResourceLocation location = GeneticHelper.getSpeciesLoc(stack);
            if (location == null) {
                return bakedModel;
            }
            cacheMap.computeIfAbsent(location, loc -> {
                BakedModel[] beeModels = new BakedModel[3];
                Species species = GeneticHelper.getSpecies(stack, true);
                for (int i = 0; i < 3; ++i) {
                    beeModels[i] = species == null ? bakedModel : new BeeModel(Minecraft.m_91087_().m_91304_().getModel(species.getModels().get(i)));
                }
                return new Variant(beeModels[0], beeModels[1], beeModels[2]);
            });
            if (stack.m_150930_((Item)ItemsRegistration.QUEEN.get())) {
                return BeeOverrideList.cacheMap.get((Object)location).queen;
            }
            if (stack.m_150930_((Item)ItemsRegistration.PRINCESS.get())) {
                return BeeOverrideList.cacheMap.get((Object)location).princess;
            }
            return BeeOverrideList.cacheMap.get((Object)location).drone;
        }
    }

    private static class BeeModel
    extends BakedModelWrapper<BakedModel> {
        private final BakedModel model;

        BeeModel(BakedModel baked) {
            super(baked);
            this.model = baked;
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            if (side == null) {
                return this.model.m_213637_(state, side, rand);
            }
            return List.of();
        }

        public BakedModel applyTransform(ItemDisplayContext ctx, PoseStack poseStack, boolean applyLeftHandTransform) {
            this.m_7442_().m_269404_(ctx).m_111763_(applyLeftHandTransform, poseStack);
            return this;
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return List.of(this);
        }
    }

    private static class BeeOverrideModel
    extends BakedModelWrapper<BakedModel> {
        private final ItemOverrides overrideList = new BeeOverrideList();

        BeeOverrideModel(BakedModel originalModel) {
            super(originalModel);
        }

        public ItemOverrides m_7343_() {
            return this.overrideList;
        }
    }

    public record Variant(BakedModel drone, BakedModel princess, BakedModel queen) {
    }
}

