/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.jei.ingredient;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.compat.jei.ingredient.ComplicatedIngredients;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import java.util.HashSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockIngredientHelper
implements IIngredientHelper<Block> {
    public IIngredientType<Block> getIngredientType() {
        return ComplicatedIngredients.BLOCK;
    }

    public String getDisplayName(Block ingredient) {
        return "Block: " + ingredient.m_49954_().getString();
    }

    public String getUniqueId(Block ingredient, UidContext context) {
        return "Block:" + this.getRegistryNameForBlock(ingredient);
    }

    private String getRegistryNameForBlock(Block ingredient) {
        ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)ingredient);
        if (null == rl) {
            throw new NullPointerException("Blocks must be registered before being used as ingredients.");
        }
        return rl.toString();
    }

    public ResourceLocation getResourceLocation(Block ingredient) {
        return ResourceLocation.parse((String)this.getRegistryNameForBlock(ingredient));
    }

    public Block copyIngredient(Block ingredient) {
        return ingredient;
    }

    public String getErrorInfo(@Nullable Block block) {
        if (block == null) {
            return "Block ingredient is null";
        }
        return "complicated_bees registered an ingredient for the block " + this.getDisplayName(block) + ", registered at " + this.getRegistryNameForBlock(block) + " that has caused an error.";
    }

    public ItemStack getCheatItemStack(Block block) {
        try {
            return new ItemStack((ItemLike)block.m_5456_());
        }
        catch (IllegalArgumentException e) {
            return ItemStack.f_41583_;
        }
    }

    public boolean isHiddenFromRecipeViewersByTags(Block ingredient) {
        return true;
    }

    public static List<Block> createList() {
        HashSet blocks = new HashSet();
        ((Registry)GeneticHelper.getRegistryAccess().m_6632_(FlowerRegistration.FLOWER_REGISTRY_KEY).orElseThrow()).forEach(flower -> blocks.addAll(flower.getAllFlowerBlocks()));
        ComplicatedBees.LOGGER.debug("Added {} flower blocks to the JEI ingredient list", (Object)blocks.size());
        return blocks.stream().toList();
    }
}

