/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.network;

import com.accbdd.complicated_bees.network.packet.IModPacket;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameClientbound;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameServerbound;
import com.accbdd.complicated_bees.network.packet.MicroscopeHintClientbound;
import com.accbdd.complicated_bees.network.packet.MicroscopeHintServerbound;
import com.accbdd.complicated_bees.network.packet.TrackerSyncClientbound;
import com.accbdd.complicated_bees.network.packet.TrackerUpdateClientbound;
import com.accbdd.complicated_bees.network.packet.UpdateSorterServerbound;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String VERSION = "1.0.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("complicated_bees", "main"), () -> "1.0.0", "1.0.0"::equals, "1.0.0"::equals);

    public static void register() {
        PacketRegistry registry = new PacketRegistry(CHANNEL);
        registry.register(MicroscopeGameServerbound.class, MicroscopeGameServerbound::decode, MicroscopeGameServerbound::handle);
        registry.register(MicroscopeGameClientbound.class, MicroscopeGameClientbound::decode, MicroscopeGameClientbound::handle);
        registry.register(MicroscopeHintServerbound.class, MicroscopeHintServerbound::decode, MicroscopeHintServerbound::handle);
        registry.register(MicroscopeHintClientbound.class, MicroscopeHintClientbound::decode, MicroscopeHintClientbound::handle);
        registry.register(TrackerSyncClientbound.class, TrackerSyncClientbound::decode, TrackerSyncClientbound::handle);
        registry.register(TrackerUpdateClientbound.class, TrackerUpdateClientbound::decode, TrackerUpdateClientbound::handle);
        registry.register(UpdateSorterServerbound.class, UpdateSorterServerbound::decode, UpdateSorterServerbound::handle);
    }

    private static final class PacketRegistry {
        private final SimpleChannel channel;
        private int packetId;

        private PacketRegistry(SimpleChannel channel) {
            this.channel = channel;
        }

        public <P extends IModPacket> void register(Class<P> packetClass, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, Supplier<NetworkEvent.Context>> context) {
            this.channel.registerMessage(this.packetId++, packetClass, IModPacket::encode, decoder, context);
        }
    }
}

