/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.recipe;

import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TempUnitRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final EnumTolerance tempChange;
    private final float useChance;
    public static final RecipeSerializer<TempUnitRecipe> SERIALIZER = new RecipeSerializer<TempUnitRecipe>(){

        public TempUnitRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient input = Ingredient.m_288218_((JsonElement)json.get("input"), (boolean)false);
            EnumTolerance tempChange = EnumTolerance.getFromString(json.get("temp_change").getAsString());
            float useChance = json.get("use_chance").getAsFloat();
            return new TempUnitRecipe(pRecipeId, input, tempChange, useChance);
        }

        @Nullable
        public TempUnitRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new TempUnitRecipe(pRecipeId, Ingredient.m_43940_((FriendlyByteBuf)pBuffer), (EnumTolerance)pBuffer.m_130066_(EnumTolerance.class), pBuffer.readFloat());
        }

        public void toNetwork(FriendlyByteBuf pBuffer, TempUnitRecipe pRecipe) {
            pRecipe.getInput().m_43923_(pBuffer);
            pBuffer.m_130068_((Enum)pRecipe.tempChange);
            pBuffer.writeFloat(pRecipe.useChance);
        }
    };

    public TempUnitRecipe(ResourceLocation id, Ingredient input, EnumTolerance tempChange, float useChance) {
        this.id = id;
        this.input = input;
        this.tempChange = tempChange;
        this.useChance = useChance;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.input.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EsotericRegistration.TEMP_UNIT_RECIPE.get();
    }

    public EnumTolerance getTempChange() {
        return this.tempChange;
    }

    public float getUseChance() {
        return this.useChance;
    }

    public Ingredient getInput() {
        return this.input;
    }
}

