/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.block.entity.MicroscopeBlockEntity;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.network.PacketHandler;
import com.accbdd.complicated_bees.network.packet.MicroscopeGameClientbound;
import com.accbdd.complicated_bees.network.packet.MicroscopeHintClientbound;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.MenuRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.accbdd.complicated_bees.screen.AbstractBaseInventoryMenu;
import com.accbdd.complicated_bees.screen.slot.TagSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class MicroscopeMenu
extends AbstractBaseInventoryMenu {
    public static int SLOT_COUNT = 6;
    public static Random rand = new Random();
    private static final int INV_X = 36;
    private static final int INV_Y = 134;
    private final BlockPos pos;
    private final Player player;
    private byte[] researchCode;
    private byte[] guessCode;
    private MicroscopeGameClientbound.GameState state;
    protected int difficulty;
    protected List<Mutation> possibleMutations = List.of();
    protected int possibleMutationsCount = -1;
    protected List<Mutation> researchedMutations = List.of();
    protected int researchedMutationsCount = -1;

    public MicroscopeMenu(int windowId, Player player, BlockPos pos) {
        super(MenuRegistration.MICROSCOPE_MENU.get(), windowId, player, SLOT_COUNT, 36, 134);
        this.pos = pos;
        this.player = player;
        this.state = MicroscopeGameClientbound.GameState.CLEAR;
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof MicroscopeBlockEntity) {
            MicroscopeBlockEntity microscope = (MicroscopeBlockEntity)blockEntity;
            this.m_38897_((Slot)new TagSlot((IItemHandler)microscope.getItems(), 0, 225, 8, ItemTagGenerator.BEE){

                public void m_6654_() {
                    super.m_6654_();
                    MicroscopeMenu.this.clearGame();
                    MicroscopeMenu.this.setDifficulty();
                    MicroscopeMenu.this.queryTracker();
                }
            });
            for (int i = 0; i < 5; ++i) {
                this.m_38897_((Slot)new TagSlot((IItemHandler)microscope.getItems(), i + 1, 225, 40 + i * 18, ItemTagGenerator.RESEARCH_MATERIAL));
            }
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    if (MicroscopeMenu.this.possibleMutationsCount == -1) {
                        MicroscopeMenu.this.queryTracker();
                    }
                    return MicroscopeMenu.this.possibleMutationsCount;
                }

                public void m_6422_(int pValue) {
                    MicroscopeMenu.this.possibleMutationsCount = pValue;
                }
            });
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    if (MicroscopeMenu.this.researchedMutationsCount == -1) {
                        MicroscopeMenu.this.queryTracker();
                    }
                    return MicroscopeMenu.this.researchedMutationsCount;
                }

                public void m_6422_(int pValue) {
                    MicroscopeMenu.this.researchedMutationsCount = pValue;
                }
            });
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return MicroscopeMenu.this.difficulty;
                }

                public void m_6422_(int pValue) {
                    MicroscopeMenu.this.difficulty = pValue;
                }
            });
            microscope.setLocked(true);
            this.layoutPlayerInventorySlots((Container)player.m_150109_());
            this.setDifficulty();
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        BlockEntity blockEntity = pPlayer.m_9236_().m_7702_(this.pos);
        if (blockEntity instanceof MicroscopeBlockEntity) {
            MicroscopeBlockEntity microscope = (MicroscopeBlockEntity)blockEntity;
            microscope.setLocked(false);
        }
    }

    public void setGuess(byte[] guess) {
        this.guessCode = (byte[])guess.clone();
    }

    public boolean canSendHint() {
        for (int i = 1; i < Math.min(this.difficulty, 6); ++i) {
            if (this.m_38853_(i).m_6657_()) continue;
            return false;
        }
        return true;
    }

    public void trySendHint() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!this.player.m_9236_().f_46443_ && this.state != MicroscopeGameClientbound.GameState.WON && this.state != MicroscopeGameClientbound.GameState.FAILED) {
                if (!this.canSendHint()) {
                    return;
                }
                for (int i = 1; i < Math.min(this.difficulty, 6); ++i) {
                    this.m_38853_(i).m_7993_().m_41774_(1);
                }
                ArrayList<Integer> unguessed = new ArrayList<Integer>();
                for (int i = 0; i < this.guessCode.length; ++i) {
                    if (this.guessCode[i] != -1) continue;
                    unguessed.add(i);
                }
                byte index = ((Integer)unguessed.get(rand.nextInt(unguessed.size()))).byteValue();
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MicroscopeHintClientbound(index, this.researchCode[index]));
            }
        }
    }

    private void setDifficulty() {
        this.difficulty = this.m_38853_(0).m_7993_().m_41619_() ? 1 : (int)(5.0 * Math.log10(SpeciesRegistration.getComplexity(GeneticHelper.getSpecies(this.m_38853_(0).m_7993_(), true))) + 3.0);
        this.difficulty = Math.min(this.difficulty, 8);
        this.researchCode = new byte[this.difficulty];
        for (int i = 0; i < this.difficulty; i = (int)((byte)(i + 1))) {
            this.researchCode[i] = i;
        }
        this.shuffle();
    }

    private void clearGame() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MicroscopeGameClientbound(MicroscopeGameClientbound.GameState.CLEAR));
        }
        this.setState(MicroscopeGameClientbound.GameState.CLEAR);
    }

    public byte[] getResearchCode() {
        return this.researchCode;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    protected void queryTracker() {
        BreedingTracker tracker = BreedingTracker.getTracker(this.player);
        if (tracker == null) {
            return;
        }
        ItemStack bee = this.m_38853_(0).m_7993_();
        if (bee.m_41619_()) {
            this.possibleMutations = List.of();
            this.possibleMutationsCount = -1;
            this.researchedMutations = List.of();
            this.researchedMutationsCount = -1;
            return;
        }
        ResourceLocation species = ResourceLocation.m_135820_((String)bee.m_41783_().m_128461_("species"));
        Registry mutationRegistry = (Registry)GeneticHelper.getRegistryAccess().m_6632_(MutationRegistration.MUTATION_REGISTRY_KEY).get();
        List<Mutation> mutations = mutationRegistry.m_123024_().filter(mutation -> mutation.getFirst().equals((Object)species) || mutation.getSecond().equals((Object)species)).toList();
        List<Mutation> researched = tracker.getResearchedMutations().stream().filter(location -> {
            if (mutationRegistry.m_7745_(location) == null) {
                return false;
            }
            return ((Mutation)mutationRegistry.m_7745_(location)).getFirst().equals((Object)species) || ((Mutation)mutationRegistry.m_7745_(location)).getSecond().equals((Object)species);
        }).map(arg_0 -> ((Registry)mutationRegistry).m_7745_(arg_0)).toList();
        this.possibleMutations = mutations;
        this.possibleMutationsCount = mutations.size();
        this.researchedMutations = researched;
        this.researchedMutationsCount = researched.size();
    }

    public void research() {
        ItemStack bee = this.m_38853_(0).m_7993_();
        if (bee.m_41619_()) {
            return;
        }
        BreedingTracker tracker = BreedingTracker.getTracker(this.player);
        ResourceLocation species = ResourceLocation.m_135820_((String)bee.m_41783_().m_128461_("species"));
        Registry mutationRegistry = (Registry)GeneticHelper.getRegistryAccess().m_6632_(MutationRegistration.MUTATION_REGISTRY_KEY).get();
        Set researched = tracker.getResearchedMutations().stream().filter(location -> {
            if (mutationRegistry.m_7745_(location) == null) {
                return false;
            }
            return ((Mutation)mutationRegistry.m_7745_(location)).getFirst().equals((Object)species) || ((Mutation)mutationRegistry.m_7745_(location)).getSecond().equals((Object)species);
        }).collect(Collectors.toSet());
        List<Mutation> mutationsToDiscover = mutationRegistry.m_123024_().filter(mutation -> !researched.contains(mutationRegistry.m_7981_(mutation)) && (mutation.getFirst().equals((Object)species) || mutation.getSecond().equals((Object)species))).toList();
        if (!mutationsToDiscover.isEmpty()) {
            tracker.research(mutationsToDiscover.get(rand.nextInt(mutationsToDiscover.size())));
            this.queryTracker();
        }
    }

    public void shuffle() {
        Random rnd = new Random();
        for (int i = this.researchCode.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            byte a = this.researchCode[index];
            this.researchCode[index] = this.researchCode[i];
            this.researchCode[i] = a;
        }
        this.guessCode = new byte[this.difficulty];
        Arrays.fill(this.guessCode, (byte)-1);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index < SLOT_COUNT) {
                if (!this.m_38903_(stack, SLOT_COUNT, 36 + SLOT_COUNT, true)) {
                    return ItemStack.f_41583_;
                }
                this.researchedMutations = List.of();
                this.possibleMutations = List.of();
            }
            if (!this.m_38903_(stack, 0, SLOT_COUNT, false) && (index < 27 + SLOT_COUNT ? !this.m_38903_(stack, 27 + SLOT_COUNT, 36 + SLOT_COUNT, false) : index < 36 + SLOT_COUNT && !this.m_38903_(stack, SLOT_COUNT, 27 + SLOT_COUNT, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return MicroscopeMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.pos), (Player)player, (Block)((Block)BlocksRegistration.MICROSCOPE.get()));
    }

    public MicroscopeGameClientbound.GameState getState() {
        return this.state;
    }

    public void setState(MicroscopeGameClientbound.GameState state) {
        this.state = state;
    }
}

