/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.screen.widget;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.GeneEffect;
import com.accbdd.complicated_bees.bees.gene.GeneTolerant;
import com.accbdd.complicated_bees.bees.gene.IGene;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.item.PrincessItem;
import com.accbdd.complicated_bees.registry.GeneRegistration;
import com.accbdd.complicated_bees.screen.AbstractAnalyzerMenu;
import com.accbdd.complicated_bees.util.GuiHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AnalyzerScrollWidget
extends AbstractScrollWidget {
    private static final ResourceLocation GUI = ResourceLocation.m_214293_((String)"complicated_bees", (String)"textures/gui/analyzer.png");
    private static final int ACTIVE_COL = 84;
    private static final int INACTIVE_COL = 150;
    private static final int INDENT = 10;
    private static final int LINE_HEIGHT = 12;
    private static final int PADDING = 4;
    private final AbstractAnalyzerMenu menu;
    private int mouseX;
    private int mouseY;
    public ItemStack hoveredStack = null;
    public Component geneTooltip = null;
    private int nextLine;

    public AnalyzerScrollWidget(int pX, int pY, int pWidth, int pHeight, AbstractAnalyzerMenu menu) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        this.menu = menu;
        this.nextLine = 0;
    }

    protected int m_239019_() {
        return this.menu.isBeeAnalyzed() ? 500 : 150;
    }

    protected double m_239725_() {
        return 10.0;
    }

    protected void m_289749_(GuiGraphics pGuiGraphics, int pX, int pY, int pWidth, int pHeight) {
    }

    protected void m_239197_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.menu.isBeeAnalyzed()) {
            this.drawGeneInfo(graphics, this.menu.m_38853_(1).m_7993_(), mouseX, mouseY);
        } else {
            GuiHelper.drawWrappedText(graphics, 2 + this.m_252754_(), 2 + this.m_252907_(), 0xFFFFFF, 12, this.m_5711_(), 4, new Component[]{Component.m_237115_((String)"gui.complicated_bees.analyzer_line_1"), Component.m_237115_((String)"gui.complicated_bees.analyzer_line_2"), Component.m_237115_((String)"gui.complicated_bees.analyzer_line_3"), Component.m_237115_((String)"gui.complicated_bees.analyzer_line_4")});
            if (this.m_239030_() > (double)this.m_239509_()) {
                this.m_240206_(this.m_239509_());
            }
        }
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    private void drawGeneInfo(GuiGraphics graphics, ItemStack bee, int mouseX, int mouseY) {
        this.nextLine = 4;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.analyzer.active"), 84, this.nextLine, 0xFFFFFF);
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.analyzer.inactive"), 150, this.nextLine, 0xFFFFFF);
        this.lineBreak();
        this.lineBreak();
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.species_label"), bee, GeneRegistration.SPECIES.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.lifespan_label"), bee, GeneRegistration.LIFESPAN.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.productivity_label"), bee, GeneRegistration.PRODUCTIVITY.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.flower_label"), bee, GeneRegistration.FLOWER.get());
        this.lineBreak();
        this.drawTolerantGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.humidity_label"), bee, GeneRegistration.HUMIDITY.get());
        this.drawTolerantGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.temperature_label"), bee, GeneRegistration.TEMPERATURE.get());
        this.lineBreak();
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.territory_label"), bee, GeneRegistration.TERRITORY.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.effect_label"), bee, GeneRegistration.EFFECT.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.fertility_label"), bee, GeneRegistration.FERTILITY.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.active_time_label"), bee, GeneRegistration.ACTIVE_TIME.get());
        this.lineBreak();
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.cave_dwelling_label"), bee, (IGene)GeneRegistration.CAVE_DWELLING.get());
        this.drawGeneValues(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.weatherproof_label"), bee, (IGene)GeneRegistration.WEATHERPROOF.get());
        this.lineBreak();
        this.lineBreak();
        this.drawProducts(graphics, bee);
        this.lineBreak();
        if (bee.m_204117_(ItemTagGenerator.ROYAL)) {
            this.drawTextCentered(graphics, (Component)Component.m_237110_((String)"gui.complicated_bees.generations", (Object[])new Object[]{PrincessItem.getGeneration(bee)}), 107, this.nextLine, 9237814);
            this.lineBreak();
            this.lineBreak();
        }
        this.lineBreak();
        this.drawTaxonomy(graphics, bee);
        this.lineBreak();
        this.drawFlavor(graphics, bee);
    }

    private void drawText(GuiGraphics graphics, Component component, int x, int color) {
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, component, x + this.m_252754_(), this.nextLine + this.m_252907_(), color, false);
        this.nextLine += 12;
    }

    private void drawText(GuiGraphics graphics, Component component, int x, int y, int color) {
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, component, x + this.m_252754_(), y + this.m_252907_(), color, false);
    }

    private void drawTextCentered(GuiGraphics graphics, Component component, int x, int y, int color) {
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, component, x + this.m_252754_(), y + this.m_252907_(), color);
    }

    private void lineBreak() {
        this.nextLine += 6;
    }

    private int getAdjustedMouseY() {
        return (int)((double)this.mouseY + this.m_239030_() - (double)this.m_252907_());
    }

    private int getAdjustedMouseX() {
        return this.mouseX - this.m_252754_();
    }

    /*
     * Unable to fully structure code
     */
    private void drawGeneValues(GuiGraphics graphics, Component label, ItemStack bee, IGene<?> gene) {
        block2: {
            block3: {
                active = GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), true);
                inactive = GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), false);
                this.drawText(graphics, label, 4, this.nextLine, 0xFFFFFF);
                this.drawText(graphics, (Component)active.getTranslationKey(), 84, this.nextLine, active.isDominant() != false ? 15086117 : 2457574);
                this.drawText(graphics, (Component)inactive.getTranslationKey(), 150, this.nextLine, inactive.isDominant() != false ? 15086117 : 2457574);
                if (!(gene instanceof GeneEffect)) break block2;
                if (this.getAdjustedMouseX() < 84 || this.getAdjustedMouseX() > 84 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)active.getTranslationKey()) || this.getAdjustedMouseY() < this.nextLine || this.getAdjustedMouseY() > this.nextLine + 12) break block3;
                this.geneTooltip = ((GeneEffect)active).getDescriptionKey();
                break block2;
            }
            if (this.getAdjustedMouseX() < 150 || this.getAdjustedMouseX() > 150 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)active.getTranslationKey()) || this.getAdjustedMouseY() < this.nextLine) ** GOTO lbl-1000
            v0 = this.getAdjustedMouseY();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            if (v0 <= this.nextLine + 9) {
                this.geneTooltip = ((GeneEffect)inactive).getDescriptionKey();
            } else lbl-1000:
            // 2 sources

            {
                this.geneTooltip = null;
            }
        }
        this.nextLine += 12;
    }

    private void drawGeneValues(GuiGraphics graphics, Component label, ItemStack bee, IGene<?> gene, int y) {
        IGene<?> active = GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), true);
        IGene<?> inactive = GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), false);
        this.drawText(graphics, label, 4, y, 0xFFFFFF);
        this.drawText(graphics, (Component)active.getTranslationKey(), 84, y, active.isDominant() ? 15086117 : 2457574);
        this.drawText(graphics, (Component)inactive.getTranslationKey(), 150, y, inactive.isDominant() ? 15086117 : 2457574);
    }

    private void drawGeneTolerance(GuiGraphics graphics, ItemStack bee, GeneTolerant<?> gene, int x, int x2, int y) {
        GeneTolerant active = (GeneTolerant)GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), true);
        GeneTolerant inactive = (GeneTolerant)GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), false);
        this.drawText(graphics, active.getTolerance().getTranslationKey(), x, y, active.isDominant() ? 15086117 : 2457574);
        this.drawText(graphics, inactive.getTolerance().getTranslationKey(), x2, y, inactive.isDominant() ? 15086117 : 2457574);
    }

    private void drawToleranceIcons(GuiGraphics graphics, ItemStack bee, GeneTolerant<?> gene, int x, int x2, int y) {
        x += this.m_252754_();
        x2 += this.m_252754_();
        y += this.m_252907_() - 2;
        GeneTolerant active = (GeneTolerant)GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), true);
        GeneTolerant inactive = (GeneTolerant)GeneticHelper.getGene(bee, ComplicatedBees.GENE_REGISTRY.get().getKey(gene), false);
        if (active.getTolerance().down != 0 && active.getTolerance().up != 0) {
            graphics.m_280218_(GUI, x, y, 14, 246, 7, 10);
        } else if (active.getTolerance().down != 0) {
            graphics.m_280218_(GUI, x, y, 7, 246, 7, 10);
        } else if (active.getTolerance().up != 0) {
            graphics.m_280218_(GUI, x, y, 0, 246, 7, 10);
        } else {
            graphics.m_280218_(GUI, x, y, 21, 246, 7, 10);
        }
        if (inactive.getTolerance().down != 0 && inactive.getTolerance().up != 0) {
            graphics.m_280218_(GUI, x2, y, 14, 246, 7, 10);
        } else if (inactive.getTolerance().down != 0) {
            graphics.m_280218_(GUI, x2, y, 7, 246, 7, 10);
        } else if (inactive.getTolerance().up != 0) {
            graphics.m_280218_(GUI, x2, y, 0, 246, 7, 10);
        } else {
            graphics.m_280218_(GUI, x2, y, 21, 246, 7, 10);
        }
    }

    private void drawTolerantGeneValues(GuiGraphics graphics, Component label, ItemStack bee, GeneTolerant<?> gene) {
        this.drawGeneValues(graphics, label, bee, gene, this.nextLine);
        this.nextLine += 12;
        this.drawText(graphics, (Component)Component.m_237115_((String)"gene.complicated_bees.tolerance_label"), 14, this.nextLine, 0xFFFFFF);
        this.drawToleranceIcons(graphics, bee, gene, 84, 150, this.nextLine);
        this.drawGeneTolerance(graphics, bee, gene, 94, 160, this.nextLine);
        this.nextLine += 12;
    }

    private void drawTaxonomy(GuiGraphics graphics, ItemStack bee) {
        Species species = GeneticHelper.getSpecies(bee, true);
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.taxonomy"), 4, 0xFFFFFF);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 6746855, (Component)Component.m_237115_((String)"gui.complicated_bees.kingdom_label"));
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.kingdom"), 4, 6746855);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 7791530, (Component)Component.m_237115_((String)"gui.complicated_bees.class_label"));
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.class"), 14, 7791530);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 10210929, (Component)Component.m_237115_((String)"gui.complicated_bees.order_label"));
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.order"), 24, 10210929);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 12694347, (Component)Component.m_237115_((String)"gui.complicated_bees.family_label"));
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.family"), 34, 12694347);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 14783048, (Component)Component.m_237115_((String)"gui.complicated_bees.genus_label"));
        this.drawText(graphics, (Component)GeneticHelper.getGenusTaxonomyKey(species), 44, 14783048);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 15887715, (Component)Component.m_237115_((String)"gui.complicated_bees.species_taxonomy_label"));
        this.drawText(graphics, (Component)GeneticHelper.getSpeciesTaxonomyKey(species), 54, 15887715);
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 0xFFFFFF, (Component)Component.m_237115_((String)"gui.complicated_bees.authority_label").m_7220_((Component)GeneticHelper.getAuthorityKey(species)));
        this.nextLine += 12;
    }

    private void drawFlavor(GuiGraphics graphics, ItemStack bee) {
        Species species = GeneticHelper.getSpecies(bee, true);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        this.nextLine = GuiHelper.drawWrappedText(graphics, 4, this.nextLine, 0xA4A4A4, 12, this.m_5711_(), 4, new Component[]{GeneticHelper.getFlavorTextKey(species).m_130940_(ChatFormatting.ITALIC)});
        graphics.m_280168_().m_85849_();
        this.nextLine -= 6;
        GuiHelper.drawRightAlignedText(graphics, this.m_5711_() - 4 + this.m_252754_(), this.nextLine + this.m_252907_(), 0xA4A4A4, (Component)Component.m_237113_((String)"-").m_7220_((Component)GeneticHelper.getFlavorTextAuthorKey(species)));
        this.nextLine += 12;
    }

    private void drawProducts(GuiGraphics graphics, ItemStack bee) {
        int y;
        int x;
        int i;
        Species species = GeneticHelper.getSpecies(bee, true);
        List<Product> products = species.getProducts();
        List<Product> specProducts = species.getSpecialtyProducts();
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.products_label"), 4, 0xFFFFFF);
        this.hoveredStack = null;
        for (i = 0; i < products.size(); ++i) {
            x = 4 + 51 * (i % 4) + this.m_252754_();
            y = this.nextLine + 21 * (i / 4) + this.m_252907_();
            graphics.m_280480_(products.get(i).getStack(), x, y);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("- " + (int)(products.get(i).getChance() * 100.0f) + "%")), x + 18, y + 5, 0xFFFFFF);
            if (this.mouseX < x || this.mouseX > x + 16 || !((double)this.mouseY + this.m_239030_() >= (double)y) || !((double)this.mouseY + this.m_239030_() <= (double)(y + 16))) continue;
            this.hoveredStack = products.get(i).getStack();
        }
        this.nextLine += 21 * (products.size() / 4 + 1);
        this.drawText(graphics, (Component)Component.m_237115_((String)"gui.complicated_bees.specialty_products_label"), 4, 0xFFFFFF);
        for (i = 0; i < specProducts.size(); ++i) {
            x = 4 + 51 * (i % 4) + this.m_252754_();
            y = this.nextLine + 21 * (i / 4) + this.m_252907_();
            graphics.m_280480_(specProducts.get(i).getStack(), x, y);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("- " + (int)(specProducts.get(i).getChance() * 100.0f) + "%")), x + 18, y + 5, 0xFFFFFF);
            if (this.mouseX < x || this.mouseX > x + 16 || !((double)this.mouseY + this.m_239030_() >= (double)y) || !((double)this.mouseY + this.m_239030_() <= (double)(y + 16))) continue;
            this.hoveredStack = specProducts.get(i).getStack();
        }
        this.nextLine += 21 * (specProducts.size() / 4 + 1);
    }
}

