/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class GuiHelper {
    public static int drawWrappedText(GuiGraphics graphics, int x, int y, int color, int lineHeight, int maxWidth, int padding, Component ... components) {
        int curY = y;
        for (Component component : components) {
            String[] linebroken;
            for (String prewrap : linebroken = component.getString().split("\\r?\\n")) {
                List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)prewrap).m_130948_(component.m_7383_()), maxWidth - padding * 2);
                for (FormattedCharSequence line : lines) {
                    graphics.m_280648_(Minecraft.m_91087_().f_91062_, line, x + padding, curY, color);
                    curY += lineHeight;
                }
            }
            curY += lineHeight / 2;
        }
        return curY;
    }

    public static int drawCenteredWrappedText(GuiGraphics graphics, int x, int y, int color, int lineHeight, int maxWidth, int padding, Component ... components) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int curY = y + 9 / 2;
        ArrayList paragraphs = new ArrayList();
        for (Component component : components) {
            String[] linebroken;
            if (component == null) continue;
            ArrayList paragraphLines = new ArrayList();
            for (String prewrap : linebroken = component.getString().split("\\r?\\n")) {
                List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)prewrap).m_130948_(component.m_7383_()), maxWidth - padding * 2);
                paragraphLines.addAll(lines);
            }
            paragraphs.add(paragraphLines);
            curY -= paragraphLines.size() * (lineHeight / 2);
        }
        curY -= (paragraphs.size() - 1) * (lineHeight / 4);
        for (List list : paragraphs) {
            for (FormattedCharSequence line : list) {
                graphics.m_280364_(Minecraft.m_91087_().f_91062_, line, x, curY, color);
                curY += lineHeight;
            }
            curY += lineHeight / 2;
        }
        return curY;
    }

    public static int drawTopAlignedCenteredWrappedText(GuiGraphics graphics, int x, int y, int color, int lineHeight, int maxWidth, int padding, Component ... components) {
        int curY = y;
        ArrayList paragraphs = new ArrayList();
        for (Component component : components) {
            String[] linebroken;
            if (component == null) continue;
            ArrayList paragraphLines = new ArrayList();
            for (String prewrap : linebroken = component.getString().split("\\r?\\n")) {
                List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)prewrap).m_130948_(component.m_7383_()), maxWidth - padding * 2);
                paragraphLines.addAll(lines);
            }
            paragraphs.add(paragraphLines);
        }
        for (List list : paragraphs) {
            for (FormattedCharSequence line : list) {
                graphics.m_280364_(Minecraft.m_91087_().f_91062_, line, x, curY, color);
                curY += lineHeight;
            }
            curY += lineHeight / 2;
        }
        return curY;
    }

    public static void drawRightAlignedText(GuiGraphics graphics, int x, int y, int color, Component component) {
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, component, x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component), y, color);
    }

    public static void drawBorderedRectangle(GuiGraphics graphics, int pX, int pY, int pWidth, int pHeight, int borderWidth, int borderColor, int fillColor) {
        graphics.m_280509_(pX, pY, pX + pWidth, pY + borderWidth, borderColor);
        graphics.m_280509_(pX, pY + pHeight - borderWidth, pX + pWidth, pY + pHeight, borderColor);
        graphics.m_280509_(pX, pY + borderWidth, pX + borderWidth, pY + pHeight - borderWidth, borderColor);
        graphics.m_280509_(pX + pWidth - borderWidth, pY + borderWidth, pX + pWidth, pY + pHeight - borderWidth, borderColor);
        graphics.m_280509_(pX + borderWidth, pY + borderWidth, pX + pWidth - borderWidth, pY + pHeight - borderWidth, fillColor);
    }
}

