/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.util;

import com.accbdd.complicated_bees.block.GyrofugeBlock;
import com.accbdd.complicated_bees.block.MellariumBlock;
import com.accbdd.complicated_bees.block.entity.gyrofuge.AbstractGyrofugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.GyrofugeBaseBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.GyrofugeControllerBlockEntity;
import com.accbdd.complicated_bees.block.entity.mellarium.AbstractMellariumBlockEntity;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumBaseBlockEntity;
import com.accbdd.complicated_bees.block.entity.mellarium.MellariumControllerBlockEntity;
import com.accbdd.complicated_bees.multiblock.GyrofugeLogic;
import com.accbdd.complicated_bees.multiblock.MellariumLogic;
import com.accbdd.complicated_bees.registry.BlocksRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.util.BlockPosBoxIterator;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MultiblockHelper {
    public static MellariumLogic tryBuildMellarium(Level level, BlockPos pos, @Nullable UUID owner) {
        if (level.m_7702_(pos) instanceof AbstractMellariumBlockEntity) {
            BlockPosBoxIterator centerIterator = new BlockPosBoxIterator(pos, 1, 1);
            while (centerIterator.hasNext()) {
                BlockPos testCenter = (BlockPos)centerIterator.next();
                if (!MultiblockHelper.isValidMellarium(level, testCenter)) continue;
                return MultiblockHelper.buildMellarium(level, testCenter, owner);
            }
        }
        return null;
    }

    public static boolean isValidMellarium(Level level, BlockPos center) {
        if (level == null || !(level.m_7702_(center) instanceof MellariumBaseBlockEntity) && !(level.m_7702_(center) instanceof MellariumControllerBlockEntity)) {
            return false;
        }
        BlockPosBoxIterator structureIterator = new BlockPosBoxIterator(center.m_7918_(-1, -1, -1), center.m_7918_(1, 1, 1));
        while (structureIterator.hasNext()) {
            BlockPos structurePos = (BlockPos)structureIterator.next();
            BlockEntity blockEntity = level.m_7702_(structurePos);
            if (blockEntity instanceof AbstractMellariumBlockEntity) {
                AbstractMellariumBlockEntity mellariumBlock = (AbstractMellariumBlockEntity)blockEntity;
                if (mellariumBlock.getLogic() != null && !level.m_5776_()) {
                    return false;
                }
                if (mellariumBlock instanceof MellariumBaseBlockEntity || structurePos.m_123342_() <= center.m_123342_()) continue;
                return false;
            }
            if (level.m_7702_(structurePos) instanceof MellariumControllerBlockEntity && structurePos.equals((Object)center)) continue;
            return false;
        }
        return true;
    }

    public static MellariumLogic buildMellarium(Level level, BlockPos center, UUID owner) {
        level.m_46597_(center, (BlockState)((MellariumBlock)((Object)BlocksRegistration.MELLARIUM_CONTROLLER.get())).m_49966_().m_61124_(EsotericRegistration.ASSEMBLED, (Comparable)((Object)EsotericRegistration.AssembledStatus.side)));
        return new MellariumLogic(level, center, owner);
    }

    public static GyrofugeLogic tryBuildGyrofuge(Level level, BlockPos pos) {
        if (level.m_7702_(pos) instanceof AbstractGyrofugeBlockEntity) {
            BlockPosBoxIterator centerIterator = new BlockPosBoxIterator(pos, 1, 1);
            while (centerIterator.hasNext()) {
                BlockPos testCenter = (BlockPos)centerIterator.next();
                if (!MultiblockHelper.isValidGyrofuge(level, testCenter)) continue;
                return MultiblockHelper.buildGyrofuge(level, testCenter);
            }
        }
        return null;
    }

    public static boolean isValidGyrofuge(Level level, BlockPos center) {
        if (level == null || !(level.m_7702_(center) instanceof GyrofugeBaseBlockEntity) && !(level.m_7702_(center) instanceof GyrofugeControllerBlockEntity)) {
            return false;
        }
        BlockPosBoxIterator structureIterator = new BlockPosBoxIterator(center.m_7918_(-1, -1, -1), center.m_7918_(1, 1, 1));
        while (structureIterator.hasNext()) {
            BlockPos structurePos = (BlockPos)structureIterator.next();
            BlockEntity blockEntity = level.m_7702_(structurePos);
            if (blockEntity instanceof AbstractGyrofugeBlockEntity) {
                AbstractGyrofugeBlockEntity gyrofugeBlock = (AbstractGyrofugeBlockEntity)blockEntity;
                if (gyrofugeBlock.getLogic() != null && !level.m_5776_()) {
                    return false;
                }
                if (gyrofugeBlock instanceof GyrofugeBaseBlockEntity || structurePos.m_123342_() <= center.m_123342_()) continue;
                return false;
            }
            if (level.m_7702_(structurePos) instanceof GyrofugeControllerBlockEntity && structurePos.equals((Object)center)) continue;
            return false;
        }
        return true;
    }

    public static GyrofugeLogic buildGyrofuge(Level level, BlockPos center) {
        level.m_46597_(center, (BlockState)((GyrofugeBlock)((Object)BlocksRegistration.GYROFUGE_CONTROLLER.get())).m_49966_().m_61124_(EsotericRegistration.ASSEMBLED, (Comparable)((Object)EsotericRegistration.AssembledStatus.side)));
        return new GyrofugeLogic(level, center);
    }
}

