/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class Util {
    public static boolean canSeeSky(Level level, BlockPos pos) {
        if (level.m_45527_(pos)) {
            return true;
        }
        if (level.m_6042_().f_63856_()) {
            return false;
        }
        if (!level.m_6042_().f_223549_()) {
            for (int y = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_(); y > pos.m_123342_(); --y) {
                if (level.m_8055_(new BlockPos(pos.m_123341_(), y, pos.m_123343_())).m_60631_((BlockGetter)level, pos)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean weakNbtMatch(CompoundTag match, CompoundTag pattern) {
        for (String key : pattern.m_128431_()) {
            if (Objects.equals(match.m_128423_(key), pattern.m_128423_(key))) continue;
            return false;
        }
        return true;
    }

    public static void moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory) {
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.m_41619_()) continue;
            ItemStack remainder = Util.insertItem(targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.m_41613_() - remainder.m_41613_();
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            Util.insertItem(targetInventory, sourceStack, false);
        }
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                emptySlots.add(i);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack) || !(stack = handler.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

