/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.effect;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.effect.BeeEffect;
import com.accbdd.complicated_bees.bees.gene.GeneTerritory;
import com.accbdd.complicated_bees.util.BlockPosSpiralIterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class TerraformEffect
extends BeeEffect {
    private static Random rand = new Random();
    private ResourceKey<Biome> biome;

    public TerraformEffect(ResourceKey<Biome> biome) {
        this.biome = biome;
    }

    @Override
    public void runEffect(BlockEntity apiary, ItemStack queen, int cycleProgress) {
        if (cycleProgress == 0 && rand.nextFloat() < 20.02f) {
            int[] territory = (int[])GeneticHelper.getGeneValue(queen, GeneTerritory.ID, true);
            ServerLevel level = (ServerLevel)apiary.m_58904_();
            BlockPosSpiralIterator iterator = new BlockPosSpiralIterator(apiary.m_58899_(), territory[0], territory[1]);
            while (iterator.hasNext()) {
                ChunkAccess chunkaccess;
                BlockPos pos = (BlockPos)iterator.next();
                if (!(pos.m_123342_() - 1 > apiary.m_58904_().m_141937_() & !apiary.m_58904_().m_204166_(TerraformEffect.quantize(pos)).m_203565_(this.biome)) || (chunkaccess = level.m_46865_(pos)) == null) continue;
                BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)TerraformEffect.quantize(pos.m_7918_(-2, -2, -2)), (Vec3i)TerraformEffect.quantize(pos.m_7918_(2, 2, 2)));
                chunkaccess.m_183442_(TerraformEffect.makeResolver(chunkaccess, boundingBox, (Holder<Biome>)((Holder)((Registry)GeneticHelper.getRegistryAccess().m_6632_(Registries.f_256952_).get()).m_203636_(this.biome).get())), level.m_7726_().m_214994_().m_224579_());
                chunkaccess.m_8092_(true);
                if (!apiary.m_58904_().m_204166_(TerraformEffect.quantize(pos)).m_203565_(this.biome)) continue;
                level.m_7726_().f_8325_.m_274524_(List.of(chunkaccess));
                break;
            }
        }
    }

    private static BiomeResolver makeResolver(ChunkAccess pChunk, BoundingBox pTargetRegion, Holder<Biome> pReplacementBiome) {
        return (x, y, z, sampler) -> {
            int i = QuartPos.m_175402_((int)x);
            int j = QuartPos.m_175402_((int)y);
            int k = QuartPos.m_175402_((int)z);
            Holder holder = pChunk.m_203495_(x, y, z);
            if (pTargetRegion.m_260866_(i, j, k)) {
                return pReplacementBiome;
            }
            return holder;
        };
    }

    private static int quantize(int pValue) {
        return QuartPos.m_175402_((int)QuartPos.m_175400_((int)pValue));
    }

    private static BlockPos quantize(BlockPos pPos) {
        return new BlockPos(TerraformEffect.quantize(pPos.m_123341_()), TerraformEffect.quantize(pPos.m_123342_()), TerraformEffect.quantize(pPos.m_123343_()));
    }
}

