/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.gene.enums;

import com.accbdd.complicated_bees.ComplicatedBees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public enum EnumHumidity {
    DRY("dry"),
    NORMAL("normal"),
    WET("wet");

    public final String name;

    private EnumHumidity(String name) {
        this.name = name;
    }

    public static EnumHumidity getFromValue(float downfall) {
        if (downfall > 0.85f) {
            return WET;
        }
        if (downfall > 0.3f) {
            return NORMAL;
        }
        return DRY;
    }

    public static EnumHumidity getFromBiome(Holder<Biome> biome) {
        return EnumHumidity.getFromValue(((Biome)biome.m_203334_()).getModifiedClimateSettings().f_47683_());
    }

    public static EnumHumidity getFromPosition(Level level, BlockPos pos) {
        return EnumHumidity.getFromBiome((Holder<Biome>)level.m_204166_(pos));
    }

    public static EnumHumidity getFromString(String str) {
        return switch (str.toLowerCase()) {
            case "wet" -> WET;
            case "normal" -> NORMAL;
            case "dry" -> DRY;
            default -> {
                ComplicatedBees.LOGGER.warn("tried to convert unknown string {} to humidity; returning normal", (Object)str);
                yield NORMAL;
            }
        };
    }

    public String toString() {
        return this.name;
    }

    public MutableComponent getTranslationKey() {
        return Component.m_237115_((String)("gene.complicated_bees.humidity." + this.toString()));
    }
}

