/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.block.entity.ICentrifuge;
import com.accbdd.complicated_bees.recipe.CentrifugeRecipe;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCentrifugeBlockEntity
extends BlockEntity
implements ICentrifuge {
    public static final String ITEMS_INPUT_TAG = "input_items";
    public static final String ITEMS_OUTPUT_TAG = "output_items";
    public static final String ITEMS_UPGRADE_TAG = "upgrade_items";
    public static final String ENERGY_TAG = "energy";
    protected ItemStackHandler inputItems = this.createInputHandler();
    protected ItemStackHandler outputItems = this.createOutputHandler();
    protected ItemStackHandler upgradeItems = this.createUpgradeHandler();
    protected IEnergyStorage energyStorage = this.createEnergyStorage();
    public final Stack<ItemStack> outputBuffer = new Stack();
    public static final String OUTPUT_BUFFER_TAG = "output_buffer";
    private final ContainerData data;
    private final RecipeManager.CachedCheck<Container, CentrifugeRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)EsotericRegistration.CENTRIFUGE_RECIPE.get()));
    private int progress;
    private int maxProgress;
    private int activeUsage = this.getActiveEnergyUsage();
    private int idleUsage = this.getIdleEnergyUsage();
    private int energyUsage;
    private boolean isCrafting;

    public AbstractCentrifugeBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.maxProgress = this.getMaxProgress();
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> AbstractCentrifugeBlockEntity.this.progress;
                    case 1 -> AbstractCentrifugeBlockEntity.this.getMaxProgress();
                    case 2 -> AbstractCentrifugeBlockEntity.this.getEnergyUsage();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        AbstractCentrifugeBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        AbstractCentrifugeBlockEntity.this.setMaxProgress(value);
                        break;
                    }
                    case 2: {
                        AbstractCentrifugeBlockEntity.this.setEnergyUsage(value);
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.getItemHandler().invalidate();
        this.getInputItemHandler().invalidate();
        this.getOutputItemHandler().invalidate();
        this.getUpgradeItemHandler().invalidate();
        this.getEnergyHandler().invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler().cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_INPUT_TAG, (Tag)this.inputItems.serializeNBT());
        tag.m_128365_(ITEMS_OUTPUT_TAG, (Tag)this.outputItems.serializeNBT());
        tag.m_128365_(ITEMS_UPGRADE_TAG, (Tag)this.upgradeItems.serializeNBT());
        ListTag bufferTag = new ListTag();
        for (ItemStack stack : this.outputBuffer) {
            bufferTag.add((Object)stack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(OUTPUT_BUFFER_TAG, (Tag)bufferTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_INPUT_TAG)) {
            this.inputItems.deserializeNBT(tag.m_128469_(ITEMS_INPUT_TAG));
        }
        if (tag.m_128441_(ITEMS_OUTPUT_TAG)) {
            this.outputItems.deserializeNBT(tag.m_128469_(ITEMS_OUTPUT_TAG));
        }
        if (tag.m_128441_(OUTPUT_BUFFER_TAG)) {
            for (Tag itemCompound : tag.m_128437_(OUTPUT_BUFFER_TAG, 10)) {
                this.outputBuffer.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)itemCompound)));
            }
        }
        if (tag.m_128441_(ITEMS_UPGRADE_TAG)) {
            this.upgradeItems.deserializeNBT(tag.m_128469_(ITEMS_UPGRADE_TAG));
        }
    }

    public void tickServer() {
        if (!this.outputBuffer.empty()) {
            this.tryEmptyBuffer();
        }
        if (this.energyStorage == null) {
            return;
        }
        this.energyStorage.extractEnergy(this.getIdleEnergyUsage(), false);
        if (!this.getCurrentlyProcessing().isEmpty() && this.outputBuffer.empty()) {
            if (this.energyStorage.getEnergyStored() > this.getActiveEnergyUsage()) {
                this.isCrafting = true;
                this.energyStorage.extractEnergy(this.getActiveEnergyUsage(), false);
                ++this.progress;
                this.m_6596_();
                if (this.progress >= this.getMaxProgress()) {
                    for (ItemStack stack : this.getCurrentlyProcessing()) {
                        this.craftItem(stack);
                    }
                    this.setProgress(0);
                }
            } else {
                this.lowerProgress();
            }
        } else {
            this.lowerProgress();
        }
    }

    private void lowerProgress() {
        this.isCrafting = false;
        if (this.progress > 0) {
            --this.progress;
        }
    }

    private void tryEmptyBuffer() {
        while (!this.outputBuffer.empty()) {
            ItemStack next = this.outputBuffer.pop();
            if ((next = ItemHandlerHelper.insertItem((IItemHandler)this.outputItems, (ItemStack)next, (boolean)false)) == ItemStack.f_41583_ || next.m_150930_(Items.f_41852_)) {
                this.m_6596_();
                continue;
            }
            this.outputBuffer.push(next);
            break;
        }
    }

    @Nullable
    public CentrifugeRecipe getRecipe(ItemStack stack) {
        Optional recipeCheck = this.quickCheck.m_213657_((Container)this.getWrapper(stack), this.m_58904_());
        return recipeCheck.orElse(null);
    }

    private void craftItem(ItemStack stack) {
        CentrifugeRecipe recipe = this.getRecipe(stack);
        if (recipe == null) {
            return;
        }
        List<Product> products = this.getRecipe(stack).getOutputs();
        stack.m_41774_(1);
        for (Product product : products) {
            this.outputBuffer.push(product.getStackResult(this.getOutputMod()));
        }
    }

    private boolean canInsertIntoOutput(ItemStack stack) {
        CentrifugeRecipe recipe = this.getRecipe(stack);
        if (recipe == null) {
            return true;
        }
        ItemStack primary = ItemStack.f_41583_;
        if (!recipe.getOutputs().isEmpty()) {
            primary = recipe.getOutputs().get(0).getStack();
        }
        boolean canInsert = false;
        int stackCount = primary.m_41613_();
        for (int i = 0; i < this.outputItems.getSlots(); ++i) {
            primary = this.outputItems.insertItem(i, primary, true);
            canInsert = canInsert || primary.m_41613_() < stackCount;
        }
        return canInsert;
    }

    public RecipeWrapper getWrapper(ItemStack stack) {
        return new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack})));
    }

    protected abstract ItemStackHandler createInputHandler();

    protected abstract ItemStackHandler createOutputHandler();

    protected abstract ItemStackHandler createUpgradeHandler();

    protected abstract EnergyStorage createEnergyStorage();

    public abstract List<ItemStack> getCurrentlyProcessing();

    public abstract float getOutputMod();

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public int getActiveEnergyUsage() {
        return this.activeUsage;
    }

    @Override
    public int getIdleEnergyUsage() {
        return this.idleUsage;
    }

    @Override
    public int getEnergyUsage() {
        return this.energyUsage;
    }

    @Override
    public boolean isCrafting() {
        return this.isCrafting;
    }

    @Override
    public void setActiveEnergyUsage(int value) {
        this.activeUsage = value;
    }

    @Override
    public void setIdleEnergyUsage(int value) {
        this.idleUsage = value;
    }

    @Override
    public void setEnergyUsage(int value) {
        this.energyUsage = value;
    }

    public ContainerData getData() {
        return this.data;
    }
}

