/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.block.entity.AdaptedEnergyStorage;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.item.UpgradeItem;
import com.accbdd.complicated_bees.util.UpgradeHelper;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGeneratorBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "items";
    public static final String UPGRADES_TAG = "upgrades";
    public static final String ENERGY_TAG = "energy";
    public static final String BURN_TIME_TAG = "burn_time";
    public final int baseGenerate;
    public final int baseStorage;
    public static final int SLOT_COUNT = 4;
    public static final int SLOT = 0;
    private int generate;
    private float burnTimeMod = 1.0f;
    private final ItemStackHandler items;
    private final ItemStackHandler upgradeItems;
    private final LazyOptional<IItemHandler> itemHandler;
    private final LazyOptional<IItemHandler> upgradeItemHandler;
    private final EnergyStorage energy;
    private final LazyOptional<IEnergyStorage> energyHandler;
    private int burnTime;
    private int maxBurnTime;

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.upgradeItemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler().cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public BaseGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int baseGenerate, int baseStorage) {
        super(type, pos, state);
        this.baseGenerate = baseGenerate;
        this.baseStorage = baseStorage;
        this.generate = baseGenerate;
        this.items = this.createItemHandler();
        this.itemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.items));
        this.upgradeItems = this.createUpgradeHandler(3);
        this.upgradeItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.upgradeItems){

            @Override
            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41720_() instanceof UpgradeItem;
            }
        });
        this.energy = this.createEnergyStorage();
        this.energyHandler = LazyOptional.of(() -> new AdaptedEnergyStorage((IEnergyStorage)this.energy){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            @Override
            public boolean canReceive() {
                return false;
            }
        });
    }

    public void tickServer() {
        this.generateEnergy();
        this.distributeEnergy();
    }

    private void generateEnergy() {
        if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored() - this.generate) {
            if (this.burnTime <= 0) {
                ItemStack fuel = this.items.getStackInSlot(0);
                if (fuel.m_41619_()) {
                    return;
                }
                int burnTime = this.getBurnTime(fuel);
                this.maxBurnTime = Math.round((float)burnTime * this.burnTimeMod);
                this.setBurnTime(this.maxBurnTime);
                if (burnTime <= 0) {
                    return;
                }
                if (fuel.hasCraftingRemainingItem()) {
                    this.items.setStackInSlot(0, fuel.getCraftingRemainingItem());
                } else {
                    this.items.extractItem(0, 1, false);
                }
            } else {
                this.setBurnTime(this.burnTime - 1);
                this.energy.receiveEnergy(this.generate, false);
            }
            this.m_6596_();
        }
    }

    private void setBurnTime(int bt) {
        if (bt == this.burnTime) {
            return;
        }
        this.burnTime = bt;
        if ((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) != this.burnTime > 0) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.burnTime > 0)));
        }
        this.m_6596_();
    }

    private void distributeEnergy() {
        if (this.energy.getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IEnergyStorage energy;
            BlockEntity be = this.m_58904_().m_7702_(this.m_58899_().m_121945_(direction));
            if (be == null || (energy = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).orElse(null)) == null) continue;
            int received = energy.receiveEnergy(this.energy.getEnergyStored(), false);
            this.energy.extractEnergy(received, false);
            this.m_6596_();
        }
    }

    public int getCurrentBurnTime() {
        return this.burnTime;
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public int getStoredPower() {
        return this.energy.getEnergyStored();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
        tag.m_128365_(UPGRADES_TAG, (Tag)this.upgradeItems.serializeNBT());
        tag.m_128365_(ENERGY_TAG, this.energy.serializeNBT());
        tag.m_128365_(BURN_TIME_TAG, (Tag)IntTag.m_128679_((int)this.burnTime));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(ITEMS_TAG));
        }
        if (tag.m_128441_(UPGRADES_TAG)) {
            this.upgradeItems.deserializeNBT(tag.m_128469_(UPGRADES_TAG));
        }
        if (tag.m_128441_(ENERGY_TAG)) {
            this.energy.deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
        this.calculateUpgradeStats();
        if (tag.m_128441_(BURN_TIME_TAG)) {
            this.maxBurnTime = this.burnTime = tag.m_128451_(BURN_TIME_TAG);
        }
    }

    @Nonnull
    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(){

            protected void onContentsChanged(int slot) {
                BaseGeneratorBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return super.isItemValid(slot, stack) && BaseGeneratorBlockEntity.this.isValidInput(stack);
            }
        };
    }

    private ItemStackHandler createUpgradeHandler(int slots) {
        return new ItemStackHandler(slots){

            protected void onContentsChanged(int slot) {
                BaseGeneratorBlockEntity.this.m_6596_();
                BaseGeneratorBlockEntity.this.calculateUpgradeStats();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nonnull
    private EnergyStorage createEnergyStorage() {
        return new EnergyStorage(this.baseStorage);
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getUpgradeItemHandler() {
        return this.upgradeItemHandler;
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return this.energyHandler;
    }

    public int getMaxBurnTime() {
        return this.maxBurnTime;
    }

    public int getGenerate() {
        return this.generate;
    }

    public void calculateUpgradeStats() {
        this.generate = Math.round((float)this.baseGenerate * UpgradeHelper.getSpeedMod((IItemHandler)this.upgradeItems));
        this.burnTimeMod = UpgradeHelper.getEfficiencyMod((IItemHandler)this.upgradeItems) / UpgradeHelper.getSpeedMod((IItemHandler)this.upgradeItems);
        this.setBurnTime(0);
    }

    public abstract boolean isValidInput(ItemStack var1);

    public abstract int getBurnTime(ItemStack var1);
}

