/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.gyrofuge;

import com.accbdd.complicated_bees.block.entity.gyrofuge.AbstractGyrofugeBlockEntity;
import com.accbdd.complicated_bees.block.entity.gyrofuge.IGyrofugeTickable;
import com.accbdd.complicated_bees.multiblock.GyrofugeLogic;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class GyrofugeInputHatchBlockEntity
extends AbstractGyrofugeBlockEntity
implements IGyrofugeTickable {
    private LazyOptional<IItemHandler> gyrofugeInput;
    private int tickCount;

    public GyrofugeInputHatchBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.GYROFUGE_INPUT_HATCH_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    public void setLogic(GyrofugeLogic logic) {
        super.setLogic(logic);
        this.gyrofugeInput = logic != null ? logic.getController().getInputItemHandler() : null;
    }

    @Override
    public void onTick() {
        if (this.gyrofugeInput != null && this.tickCount++ % 4 == 0) {
            for (Direction dir : Direction.values()) {
                BlockEntity blockEntity = this.m_58904_().m_7702_(this.m_58899_().m_121945_(dir));
                if (blockEntity == null || blockEntity instanceof AbstractGyrofugeBlockEntity) continue;
                IItemHandler itemCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).resolve().orElse(null);
                IItemHandler input = this.gyrofugeInput.resolve().orElse(null);
                if (itemCap == null || input == null) continue;
                Util.moveInventoryItems(itemCap, input);
            }
            this.tickCount = 0;
        }
    }
}

