/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.command;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.Chromosome;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.IGene;
import com.accbdd.complicated_bees.bees.gene.enums.EnumHumidity;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTemperature;
import com.accbdd.complicated_bees.registry.GeneRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.registries.ForgeRegistries;

public class DumpCommands
implements Command<CommandSourceStack> {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> root, CommandDispatcher<CommandSourceStack> pDispatcher, CommandBuildContext buildContext) {
        pDispatcher.register((LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").then(Commands.m_82127_((String)"biomes").executes(DumpCommands::dumpBiomes))).then(Commands.m_82127_((String)"effects").executes(DumpCommands::dumpEffects))).then(Commands.m_82127_((String)"species").executes(DumpCommands::dumpGenes))));
    }

    private static int dumpBiomes(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        if (player == null || registryAccess == null) {
            return 0;
        }
        Registry biomes = (Registry)registryAccess.m_6632_(ForgeRegistries.Keys.BIOMES).get();
        biomes.m_123024_().forEach(entry -> player.m_213846_((Component)Component.m_237113_((String)(String.valueOf(biomes.m_7981_(entry)) + ": " + String.valueOf((Object)EnumTemperature.getFromValue(entry.getModifiedClimateSettings().f_47681_())) + ", " + String.valueOf((Object)EnumHumidity.getFromValue(entry.getModifiedClimateSettings().f_47683_()))))));
        return 1;
    }

    private static int dumpEffects(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player == null) {
            return 0;
        }
        ComplicatedBees.BEE_EFFECT_REGISTRY.get().getEntries().forEach(entry -> player.m_213846_((Component)Component.m_237115_((String)("effect.complicated_bees." + String.valueOf(((ResourceKey)entry.getKey()).m_135782_()))).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("effect.complicated_bees." + String.valueOf(((ResourceKey)entry.getKey()).m_135782_()) + ".desc")))));
        return 1;
    }

    private static int dumpGenes(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        if (player == null || registryAccess == null) {
            return 0;
        }
        Registry speciesRegistry = (Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get();
        speciesRegistry.m_123024_().forEach(species -> {
            Chromosome chromosome = species.getDefaultChromosome();
            player.m_213846_((Component)GeneticHelper.getTranslationKey(species).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.LIFESPAN.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.PRODUCTIVITY.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.FLOWER.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.HUMIDITY.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.TEMPERATURE.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.TERRITORY.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.EFFECT.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.FERTILITY.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, GeneRegistration.ACTIVE_TIME.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, (IGene)GeneRegistration.CAVE_DWELLING.get())).m_130946_(",").m_7220_(DumpCommands.geneValue(chromosome, (IGene)GeneRegistration.WEATHERPROOF.get())));
        });
        Path outputPath = Path.of("complicated_bees", "genes.csv");
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            player.m_213846_((Component)Component.m_237113_((String)("Failed to create output directory: " + e.getMessage())));
            return 0;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write("Species,Lifespan,Productivity,Flower,Humidity,Temperature,Territory,Effect,Fertility,ActiveTime,CaveDwelling,Weatherproof");
            writer.newLine();
            for (Species species2 : speciesRegistry) {
                Chromosome chromosome = species2.getDefaultChromosome();
                String line = String.join((CharSequence)",", GeneticHelper.getTranslationKey(species2).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.LIFESPAN.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.PRODUCTIVITY.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.FLOWER.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.HUMIDITY.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.TEMPERATURE.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.TERRITORY.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.EFFECT.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.FERTILITY.get()).getString(), DumpCommands.geneValue(chromosome, GeneRegistration.ACTIVE_TIME.get()).getString(), DumpCommands.geneValue(chromosome, (IGene)GeneRegistration.CAVE_DWELLING.get()).getString(), DumpCommands.geneValue(chromosome, (IGene)GeneRegistration.WEATHERPROOF.get()).getString());
                writer.write(line);
                writer.newLine();
            }
            player.m_213846_((Component)Component.m_237113_((String)"Genes dumped to .minecraft/complicated_bees/genes.csv"));
        }
        catch (IOException e) {
            e.printStackTrace();
            player.m_213846_((Component)Component.m_237113_((String)("Error writing genes.csv: " + e.getMessage())));
        }
        return 1;
    }

    private static Component geneValue(Chromosome chromosome, IGene gene) {
        return chromosome.getGene(ComplicatedBees.GENE_REGISTRY.get().getKey((Object)gene)).getTranslationKey();
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return 0;
    }
}

