/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi;

import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.compat.emi.BeeSorterDragDropEMI;
import com.accbdd.complicated_bees.compat.emi.ingredient.EmiFlower;
import com.accbdd.complicated_bees.compat.emi.recipe.BeeProduceEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.CentrifugeEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.FlowerTypeEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.HoneyGeneratorEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.HydroEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.MutationEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.MutatorEmiRecipe;
import com.accbdd.complicated_bees.compat.emi.recipe.TempUnitEmiRecipe;
import com.accbdd.complicated_bees.item.BeeNestBlockItem;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.accbdd.complicated_bees.screen.BeeSorterScreen;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class ComplicatedBeesEMI
implements EmiPlugin {
    public static final EmiStack CENTRIFUGE = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.CENTRIFUGE.get()));
    public static final EmiStack GYROFUGE = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.GYROFUGE_BASE.get()));
    public static final EmiStack APIARY = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.APIARY.get()));
    public static final EmiStack MELLARIUM = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.MELLARIUM_BASE.get()));
    public static final EmiStack MUTATOR = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.MELLARIUM_MUTATOR.get()));
    public static final EmiStack TEMP_UNIT = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.MELLARIUM_TEMP_UNIT.get()));
    public static final EmiStack HYDROREGULATOR = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.MELLARIUM_HYDROREGULATOR.get()));
    public static final EmiStack HONEY_GENERATOR = EmiStack.of((ItemLike)((ItemLike)ItemsRegistration.HONEY_GENERATOR.get()));
    public static final EmiRecipeCategory CENTRIFUGE_CATEGORY = new ComplicatedBeesRecipeCategory("centrifuge", (EmiRenderable)CENTRIFUGE, (Component)Component.m_237115_((String)"gui.complicated_bees.jei.centrifuge"));
    public static final EmiRecipeCategory BEE_PRODUCE_CATEGORY = new ComplicatedBeesRecipeCategory("bee_produce", (EmiRenderable)APIARY, (Component)Component.m_237115_((String)"gui.complicated_bees.jei.bee_products"));
    public static final EmiRecipeCategory MUTATION_CATEGORY = new ComplicatedBeesRecipeCategory("mutation", (EmiRenderable)APIARY, (Component)Component.m_237115_((String)"gui.complicated_bees.jei.mutations"));
    public static final EmiRecipeCategory FLOWER_TYPE_CATEGORY = new ComplicatedBeesRecipeCategory("flower_type", (EmiRenderable)EmiStack.of((ItemLike)Items.f_41940_), (Component)Component.m_237115_((String)"gui.complicated_bees.jei.flower_type"));
    public static final EmiRecipeCategory MUTATOR_CATEGORY = new ComplicatedBeesRecipeCategory("mutator", (EmiRenderable)MUTATOR, (Component)Component.m_237115_((String)"jei.complicated_bees.mutator"));
    public static final EmiRecipeCategory TEMP_UNIT_CATEGORY = new ComplicatedBeesRecipeCategory("temp_unit", (EmiRenderable)TEMP_UNIT, (Component)Component.m_237115_((String)"jei.complicated_bees.temp_unit"));
    public static final EmiRecipeCategory HYDROREGULATOR_CATEGORY = new ComplicatedBeesRecipeCategory("hydroregulator", (EmiRenderable)HYDROREGULATOR, (Component)Component.m_237115_((String)"jei.complicated_bees.hydroregulator"));
    public static final EmiRecipeCategory HONEY_GENERATOR_CATEGORY = new ComplicatedBeesRecipeCategory("honey_generator", (EmiRenderable)HONEY_GENERATOR, (Component)Component.m_237115_((String)"jei.complicated_bees.honey_generator"));
    public static final Comparison COMPARE_BEE = Comparison.compareData(stack -> GeneticHelper.getSpecies(stack.getItemStack(), true));

    public void register(EmiRegistry registry) {
        registry.setDefaultComparison(ItemsRegistration.DRONE.get(), COMPARE_BEE);
        registry.setDefaultComparison(ItemsRegistration.PRINCESS.get(), COMPARE_BEE);
        registry.setDefaultComparison(ItemsRegistration.QUEEN.get(), COMPARE_BEE);
        registry.setDefaultComparison(ItemsRegistration.BEE_NEST.get(), Comparison.compareData(s -> {
            CompoundTag blockEntityData = BeeNestBlockItem.m_186336_((ItemStack)s.getItemStack());
            if (blockEntityData == null) {
                return "empty";
            }
            return blockEntityData.m_128461_("species");
        }));
        registry.addCategory(CENTRIFUGE_CATEGORY);
        registry.addWorkstation(CENTRIFUGE_CATEGORY, (EmiIngredient)CENTRIFUGE);
        registry.addWorkstation(CENTRIFUGE_CATEGORY, (EmiIngredient)GYROFUGE);
        registry.addCategory(BEE_PRODUCE_CATEGORY);
        registry.addWorkstation(BEE_PRODUCE_CATEGORY, (EmiIngredient)APIARY);
        registry.addWorkstation(BEE_PRODUCE_CATEGORY, (EmiIngredient)MELLARIUM);
        registry.addCategory(MUTATION_CATEGORY);
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)APIARY);
        registry.addWorkstation(MUTATION_CATEGORY, (EmiIngredient)MELLARIUM);
        registry.addCategory(FLOWER_TYPE_CATEGORY);
        registry.addWorkstation(FLOWER_TYPE_CATEGORY, (EmiIngredient)APIARY);
        registry.addWorkstation(FLOWER_TYPE_CATEGORY, (EmiIngredient)MELLARIUM);
        registry.addCategory(MUTATOR_CATEGORY);
        registry.addWorkstation(MUTATOR_CATEGORY, (EmiIngredient)MUTATOR);
        registry.addCategory(TEMP_UNIT_CATEGORY);
        registry.addWorkstation(TEMP_UNIT_CATEGORY, (EmiIngredient)TEMP_UNIT);
        registry.addCategory(HYDROREGULATOR_CATEGORY);
        registry.addWorkstation(HYDROREGULATOR_CATEGORY, (EmiIngredient)HYDROREGULATOR);
        registry.addCategory(HONEY_GENERATOR_CATEGORY);
        registry.addWorkstation(HONEY_GENERATOR_CATEGORY, (EmiIngredient)HONEY_GENERATOR);
        registry.addDragDropHandler(BeeSorterScreen.class, (EmiDragDropHandler)new BeeSorterDragDropEMI());
        RecipeManager manager = registry.getRecipeManager();
        RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
        manager.m_44013_((RecipeType)EsotericRegistration.CENTRIFUGE_RECIPE.get()).stream().map(CentrifugeEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        manager.m_44013_((RecipeType)EsotericRegistration.MUTATOR_RECIPE.get()).stream().map(MutatorEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        manager.m_44013_((RecipeType)EsotericRegistration.TEMP_UNIT_RECIPE.get()).stream().map(TempUnitEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        manager.m_44013_((RecipeType)EsotericRegistration.HYDROREGULATOR_RECIPE.get()).stream().map(HydroEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        manager.m_44013_((RecipeType)EsotericRegistration.HONEY_GENERATOR_RECIPE.get()).stream().map(HoneyGeneratorEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        registryAccess.m_175515_(MutationRegistration.MUTATION_REGISTRY_KEY).m_123024_().map(MutationEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        registryAccess.m_175515_(SpeciesRegistration.SPECIES_REGISTRY_KEY).m_123024_().map(BeeProduceEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        registryAccess.m_175515_(FlowerRegistration.FLOWER_REGISTRY_KEY).m_123024_().forEach(flower -> {
            registry.addRecipe((EmiRecipe)new FlowerTypeEmiRecipe((Flower)flower));
            registry.addEmiStack((EmiStack)new EmiFlower((Flower)flower));
        });
    }

    private static class ComplicatedBeesRecipeCategory
    extends EmiRecipeCategory {
        private final Component name;

        public ComplicatedBeesRecipeCategory(String path, EmiRenderable icon, Component name) {
            super(ResourceLocation.m_214293_((String)"complicated_bees", (String)path), icon);
            this.name = name;
        }

        public Component getName() {
            return this.name;
        }
    }
}

