/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.jei;

import com.accbdd.complicated_bees.compat.jei.ChanceTooltipCallback;
import com.accbdd.complicated_bees.compat.jei.ComplicatedBeesJEI;
import com.accbdd.complicated_bees.recipe.HydroRecipe;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HydroRecipeCategory
implements IRecipeCategory<HydroRecipe> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)"jei/hydroregulator");
    public static final RecipeType<HydroRecipe> TYPE = new RecipeType(ID, HydroRecipe.class);
    private static final Component TITLE = Component.m_237115_((String)"jei.complicated_bees.hydroregulator");
    public final IDrawable icon;
    public final IDrawable BACKGROUND = ComplicatedBeesJEI.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)"textures/gui/jei/two_slot.png"), 0, 0, 143, 40, 143, 40);

    public HydroRecipeCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemsRegistration.MELLARIUM_HYDROREGULATOR.get()));
    }

    public RecipeType<HydroRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HydroRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 12).setSlotName("input").addIngredients(recipe.getInput());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 12).setSlotName("output").addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getOutput().getStack())).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new ChanceTooltipCallback(recipe.getOutput().getChance()));
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, HydroRecipe recipe, IFocusGroup focuses) {
        super.createRecipeExtras(builder, (Object)recipe, focuses);
        ITextWidget widget = builder.addText((FormattedText)Component.m_237110_((String)"jei.complicated_bees.modifier", (Object[])new Object[]{recipe.getHumidityChange().getTranslationKey()}), 71, 14);
        widget.setPosition(69, 5, 71, 14, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        widget.setTextAlignment(HorizontalAlignment.CENTER);
        widget.setTextAlignment(VerticalAlignment.CENTER);
        ITextWidget widget2 = builder.addText((FormattedText)Component.m_237110_((String)"jei.complicated_bees.consumption_chance", (Object[])new Object[]{String.format("%.0f%%", Float.valueOf(recipe.getUseChance() * 100.0f))}), 71, 14);
        widget2.setPosition(69, 22, 71, 14, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        widget2.setTextAlignment(HorizontalAlignment.CENTER);
        widget2.setTextAlignment(VerticalAlignment.CENTER);
    }
}

