/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static ForgeConfigSpec CONFIG_SPEC;
    public static ServerConfig SERVER_CONFIG;
    public final ForgeConfigSpec.ConfigValue<Integer> productionCycleLength;
    public final ForgeConfigSpec.ConfigValue<Integer> enviroCycleLength;
    public final ForgeConfigSpec.ConfigValue<Integer> centrifugeBaseSpeed;
    public final ForgeConfigSpec.ConfigValue<Integer> centrifugeBaseEnergy;
    public final ForgeConfigSpec.ConfigValue<Integer> furnaceGeneratorBaseEnergy;
    public final ForgeConfigSpec.ConfigValue<Integer> furnaceGeneratorBaseStorage;
    public final ForgeConfigSpec.ConfigValue<Integer> honeyGeneratorBaseEnergy;
    public final ForgeConfigSpec.ConfigValue<Integer> honeyGeneratorBaseStorage;
    public final ForgeConfigSpec.ConfigValue<Integer> mellariumCellTransfer;
    public final ForgeConfigSpec.ConfigValue<Integer> mellariumCellStorage;
    public final ForgeConfigSpec.ConfigValue<Integer> gyrofugeCellTransfer;
    public final ForgeConfigSpec.ConfigValue<Integer> gyrofugeCellStorage;
    public final ForgeConfigSpec.ConfigValue<Integer> gyrofugeBaseSpeed;
    public final ForgeConfigSpec.ConfigValue<Integer> gyrofugeBaseUsage;
    public final ForgeConfigSpec.ConfigValue<Integer> gyrofugeBaseIdleUsage;
    public final ForgeConfigSpec.ConfigValue<Integer> productivityCap;
    public final ForgeConfigSpec.ConfigValue<Float> researchBonus;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("production_cap");
        this.productivityCap = builder.comment("The absolute maximum multiplier that bees can receive from modifiers").define("productivityCap", (Object)50000);
        builder.pop();
        builder.push("cycle_length");
        this.productionCycleLength = builder.comment("How long (in ticks) one bee cycle should take.").define("productionCycleLength", (Object)200);
        this.enviroCycleLength = builder.comment("How long (in ticks) an apiary should wait between re-scanning the environment for appropriate conditions.").define("enviroCycleLength", (Object)200);
        builder.pop();
        builder.push("research");
        this.researchBonus = builder.comment("The percentage bonus researching a mutation in the microscope should grant to that mutation's chances.").define("researchBonus", (Object)Float.valueOf(0.2f));
        builder.pop();
        builder.push("rf");
        this.centrifugeBaseSpeed = builder.comment("How many ticks an unupgraded centrifuge should take to process a comb").define("centrifugeBaseSpeed", (Object)200);
        this.centrifugeBaseEnergy = builder.comment("How much rf/tick an unupgraded centrifuge should use while processing a recipe.").define("centrifugeBaseEnergy", (Object)20);
        this.furnaceGeneratorBaseEnergy = builder.comment("How much rf/tick a generator should produce while burning a fuel.").define("furnaceGeneratorBaseEnergy", (Object)20);
        this.furnaceGeneratorBaseStorage = builder.comment("How much rf a generator should be able to store.").define("furnaceGeneratorBaseStorage", (Object)100000);
        this.honeyGeneratorBaseEnergy = builder.comment("How much rf/tick a honey generator should produce while burning a fuel.").define("honeyGeneratorBaseEnergy", (Object)40);
        this.honeyGeneratorBaseStorage = builder.comment("How much rf a honey generator should be able to store.").define("honeyGeneratorBaseStorage", (Object)200000);
        this.mellariumCellTransfer = builder.comment("How much rf/tick a mellarium energy cell should be able to transfer into itself.").define("mellariumCellTransfer", (Object)2000);
        this.mellariumCellStorage = builder.comment("How much rf a mellarium energy cell should be able to store at base.").define("mellariumCellStorage", (Object)200000);
        this.gyrofugeCellTransfer = builder.comment("How much rf/tick a gyrofuge energy cell should be able to transfer into itself.").define("gyrofugeCellTransfer", (Object)2000);
        this.gyrofugeCellStorage = builder.comment("How much rf a gyrofuge energy cell should be able to store at base.").define("gyrofugeCellStorage", (Object)200000);
        this.gyrofugeBaseSpeed = builder.comment("How many ticks an unupgraded gyrofuge should take to process a comb").define("gyrofugeBaseSpeed", (Object)100);
        this.gyrofugeBaseUsage = builder.comment("How much rf/tick an unupgraded gyrofuge should use while processing a recipe.").define("gyrofugeBaseUsage", (Object)50);
        this.gyrofugeBaseIdleUsage = builder.comment("How much rf/tick an unupgraded gyrofuge should use while idle.").define("gyrofugeBaseIdleUsage", (Object)10);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
        SERVER_CONFIG = (ServerConfig)pair.getLeft();
    }
}

