/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.recipe;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.accbdd.complicated_bees.util.Util;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class CentrifugeRecipe
implements Recipe<Container> {
    private final ItemStack input;
    private final List<Product> outputs;
    private final ResourceLocation id;
    public static final RecipeSerializer<CentrifugeRecipe> SERIALIZER = new RecipeSerializer<CentrifugeRecipe>(){

        public CentrifugeRecipe fromNetwork(ResourceLocation loc, FriendlyByteBuf pBuffer) {
            ItemStack input = pBuffer.m_130267_();
            ArrayList<Product> outputs = new ArrayList<Product>();
            int listSize = pBuffer.readInt();
            for (int i = 0; i < listSize; ++i) {
                outputs.add(Product.fromNetwork(pBuffer));
            }
            return new CentrifugeRecipe(loc, input, outputs);
        }

        public CentrifugeRecipe fromJson(ResourceLocation location, JsonObject json) {
            JsonObject inputJson = json.getAsJsonObject("input");
            ResourceLocation inputItemLocation = ResourceLocation.m_135820_((String)inputJson.get("item").getAsString());
            Item inputItem = (Item)ForgeRegistries.ITEMS.getValue(inputItemLocation);
            if (inputItem == null) {
                throw new JsonParseException("could not parse input for " + String.valueOf(location));
            }
            ItemStack input = new ItemStack((ItemLike)inputItem);
            if (inputJson.has("nbt")) {
                input.m_41751_(CraftingHelper.getNBT((JsonElement)inputJson.getAsJsonObject("nbt")));
            }
            ArrayList<Product> outputs = new ArrayList<Product>();
            if (json.has("outputs")) {
                JsonArray outputsJson = json.getAsJsonArray("outputs");
                for (JsonElement element : outputsJson.asList()) {
                    DataResult result = Product.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    outputs.add((Product)((Pair)result.result().orElseThrow(() -> new NoSuchElementException("could not decode " + String.valueOf(location)))).getFirst());
                }
            }
            return new CentrifugeRecipe(location, input, outputs);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CentrifugeRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.input);
            pBuffer.writeInt(pRecipe.outputs.size());
            for (Product prod : pRecipe.outputs) {
                prod.toNetwork(pBuffer);
            }
        }
    };

    public CentrifugeRecipe(ResourceLocation id, ItemStack input, List<Product> outputs) {
        this.id = id;
        this.input = input;
        this.outputs = outputs;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        ItemStack containerInput = pContainer.m_8020_(0);
        boolean itemMatch = this.input.m_150930_(containerInput.m_41720_());
        boolean countMatch = this.input.m_41613_() <= containerInput.m_41613_();
        boolean nbtMatch = Util.weakNbtMatch(containerInput.m_41784_(), this.input.m_41784_());
        return countMatch && nbtMatch && itemMatch;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        ComplicatedBees.LOGGER.debug("tried to use assemble on a CentrifugeRecipe! Use getOutputs instead");
        return ItemStack.f_41583_;
    }

    public List<Product> getOutputs() {
        return this.outputs;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 1;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        ComplicatedBees.LOGGER.debug("tried to use getResultItem on a CentrifugeRecipe! Use getOutputs instead");
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EsotericRegistration.CENTRIFUGE_RECIPE.get();
    }
}

