/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.recipe;

import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HoneyGeneratorRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final int burnTime;
    public static final RecipeSerializer<HoneyGeneratorRecipe> SERIALIZER = new RecipeSerializer<HoneyGeneratorRecipe>(){

        public HoneyGeneratorRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient input = Ingredient.m_288218_((JsonElement)json.getAsJsonObject("input"), (boolean)false);
            int burnTime = json.get("burn_time").getAsInt();
            return new HoneyGeneratorRecipe(pRecipeId, input, burnTime);
        }

        @Nullable
        public HoneyGeneratorRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new HoneyGeneratorRecipe(pRecipeId, Ingredient.m_43940_((FriendlyByteBuf)pBuffer), pBuffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf pBuffer, HoneyGeneratorRecipe pRecipe) {
            pRecipe.getInput().m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.getBurnTime());
        }
    };

    public HoneyGeneratorRecipe(ResourceLocation id, Ingredient input, int burnTime) {
        this.id = id;
        this.input = input;
        this.burnTime = burnTime;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.input.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EsotericRegistration.HONEY_GENERATOR_RECIPE.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getBurnTime() {
        return this.burnTime;
    }
}

