/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.recipe;

import com.accbdd.complicated_bees.bees.Product;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HydroRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final Product output;
    private final EnumTolerance humidityChange;
    private final float useChance;
    public static final RecipeSerializer<HydroRecipe> SERIALIZER = new RecipeSerializer<HydroRecipe>(){

        public HydroRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient input = Ingredient.m_288218_((JsonElement)json.getAsJsonObject("input"), (boolean)false);
            Product output = (Product)((Pair)Product.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.getAsJsonObject("output")).result().get()).getFirst();
            EnumTolerance humidityChange = EnumTolerance.getFromString(json.get("humidity_change").getAsString());
            float useChance = json.get("use_chance").getAsFloat();
            return new HydroRecipe(pRecipeId, input, output, humidityChange, useChance);
        }

        @Nullable
        public HydroRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new HydroRecipe(pRecipeId, Ingredient.m_43940_((FriendlyByteBuf)pBuffer), Product.fromNetwork(pBuffer), (EnumTolerance)pBuffer.m_130066_(EnumTolerance.class), pBuffer.readFloat());
        }

        public void toNetwork(FriendlyByteBuf pBuffer, HydroRecipe pRecipe) {
            pRecipe.getInput().m_43923_(pBuffer);
            pRecipe.getOutput().toNetwork(pBuffer);
            pBuffer.m_130068_((Enum)pRecipe.humidityChange);
            pBuffer.writeFloat(pRecipe.useChance);
        }
    };

    public HydroRecipe(ResourceLocation id, Ingredient input, Product output, EnumTolerance humidityChange, float useChance) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.humidityChange = humidityChange;
        this.useChance = useChance;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.input.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EsotericRegistration.HYDROREGULATOR_RECIPE.get();
    }

    public EnumTolerance getHumidityChange() {
        return this.humidityChange;
    }

    public float getUseChance() {
        return this.useChance;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Product getOutput() {
        return this.output;
    }
}

