/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class TemplateModClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"calc").then(ClientCommandManager.argument((String)"expression", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String expression = StringArgumentType.getString((CommandContext)context, (String)"expression");
            try {
                double result = this.evaluateExpression(expression);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Result: " + result)));
            }
            catch (Exception e) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("Invalid expression: " + e.getMessage())));
            }
            return 1;
        }))).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"Usage: /calc <expression>"));
            return 0;
        })));
    }

    private double evaluateExpression(String expression) {
        expression = expression.replaceAll("\\s+", "");
        return this.evaluateTokens(expression);
    }

    private double evaluateTokens(String expr) {
        double result;
        double right;
        double left;
        int i;
        while (((String)expr).contains("(")) {
            int start = ((String)expr).lastIndexOf("(");
            int end = ((String)expr).indexOf(")", start);
            if (end == -1) {
                throw new IllegalArgumentException("Mismatched parentheses");
            }
            String subExpr = ((String)expr).substring(start + 1, end);
            double result2 = this.evaluateTokens(subExpr);
            expr = ((String)expr).substring(0, start) + result2 + ((String)expr).substring(end + 1);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder currentNumber = new StringBuilder();
        for (i = 0; i < ((String)expr).length(); ++i) {
            char c = ((String)expr).charAt(i);
            if (Character.isDigit(c) || c == '.') {
                currentNumber.append(c);
                continue;
            }
            if (c == '+' || c == '-' || c == '*' || c == '/') {
                if (currentNumber.length() > 0) {
                    tokens.add(currentNumber.toString());
                    currentNumber = new StringBuilder();
                }
                tokens.add(String.valueOf(c));
                continue;
            }
            if (c == '(' || c == ')') continue;
            throw new IllegalArgumentException("Invalid character: " + c);
        }
        if (currentNumber.length() > 0) {
            tokens.add(currentNumber.toString());
        }
        for (i = 1; i < tokens.size() - 1; i += 2) {
            String operator = (String)tokens.get(i);
            if (!operator.equals("*") && !operator.equals("/")) continue;
            left = Double.parseDouble((String)tokens.get(i - 1));
            right = Double.parseDouble((String)tokens.get(i + 1));
            if (operator.equals("*")) {
                result = left * right;
            } else {
                if (right == 0.0) {
                    throw new IllegalArgumentException("Division by zero");
                }
                result = left / right;
            }
            tokens.set(i - 1, String.valueOf(result));
            tokens.remove(i);
            tokens.remove(i);
            i -= 2;
        }
        for (i = 1; i < tokens.size() - 1; i += 2) {
            String operator = (String)tokens.get(i);
            if (!operator.equals("+") && !operator.equals("-")) continue;
            left = Double.parseDouble((String)tokens.get(i - 1));
            right = Double.parseDouble((String)tokens.get(i + 1));
            result = operator.equals("+") ? left + right : left - right;
            tokens.set(i - 1, String.valueOf(result));
            tokens.remove(i);
            tokens.remove(i);
            i -= 2;
        }
        if (tokens.size() != 1) {
            throw new IllegalArgumentException("Invalid expression");
        }
        return Double.parseDouble((String)tokens.get(0));
    }
}

