/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.afkzonepro;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AfkZonePro
extends JavaPlugin
implements Listener {
    private Map<String, AfkZone> afkZones = new HashMap<String, AfkZone>();
    private Map<UUID, String> playersInZone = new ConcurrentHashMap<UUID, String>();
    private Map<UUID, Long> playerTimeInZone = new ConcurrentHashMap<UUID, Long>();
    private Map<UUID, Selection> playerSelections = new HashMap<UUID, Selection>();
    private Map<UUID, ItemStack> afkWands = new HashMap<UUID, ItemStack>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadAfkZones();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("afkwand").setExecutor((CommandExecutor)new AfkWandCommand());
        this.getCommand("afkzonepro").setExecutor((CommandExecutor)new AfkZoneProCommand());
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::checkRewards, 20L, 1200L);
        this.getLogger().info("AfkZonePro has been enabled!");
    }

    public void onDisable() {
        this.saveAfkZones();
        this.getLogger().info("AfkZonePro has been disabled!");
    }

    private void loadAfkZones() {
        ConfigurationSection zonesSection = this.getConfig().getConfigurationSection("zones");
        if (zonesSection != null) {
            for (String zoneName : zonesSection.getKeys(false)) {
                ConfigurationSection zoneSection = zonesSection.getConfigurationSection(zoneName);
                Location corner1 = this.deserializeLocation(zoneSection.getString("corner1"));
                Location corner2 = this.deserializeLocation(zoneSection.getString("corner2"));
                int guaranteedInterval = zoneSection.getInt("guaranteed-reward.interval", 60);
                String guaranteedCommand = zoneSection.getString("guaranteed-reward.command", "");
                int chanceInterval = zoneSection.getInt("chance-reward.interval", 60);
                double chancePercentage = zoneSection.getDouble("chance-reward.chance", 10.0);
                String chanceCommand = zoneSection.getString("chance-reward.command", "");
                AfkZone zone = new AfkZone(this, zoneName, corner1, corner2, guaranteedInterval, guaranteedCommand, chanceInterval, chancePercentage, chanceCommand);
                this.afkZones.put(zoneName, zone);
            }
        }
    }

    private void saveAfkZones() {
        for (Map.Entry<String, AfkZone> entry : this.afkZones.entrySet()) {
            String zoneName = entry.getKey();
            AfkZone zone = entry.getValue();
            String path = "zones." + zoneName + ".";
            this.getConfig().set(path + "corner1", (Object)this.serializeLocation(zone.getCorner1()));
            this.getConfig().set(path + "corner2", (Object)this.serializeLocation(zone.getCorner2()));
            this.getConfig().set(path + "guaranteed-reward.interval", (Object)zone.getGuaranteedInterval());
            this.getConfig().set(path + "guaranteed-reward.command", (Object)zone.getGuaranteedCommand());
            this.getConfig().set(path + "chance-reward.interval", (Object)zone.getChanceInterval());
            this.getConfig().set(path + "chance-reward.chance", (Object)zone.getChancePercentage());
            this.getConfig().set(path + "chance-reward.command", (Object)zone.getChanceCommand());
        }
        this.saveConfig();
    }

    private String serializeLocation(Location location) {
        return location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ();
    }

    private Location deserializeLocation(String serialized) {
        String[] parts = serialized.split(",");
        return new Location(Bukkit.getWorld((String)parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
    }

    private void checkRewards() {
        for (Map.Entry<UUID, String> entry : this.playersInZone.entrySet()) {
            double random;
            long timeInZone;
            Player player;
            UUID playerId = entry.getKey();
            String zoneName = entry.getValue();
            AfkZone zone = this.afkZones.get(zoneName);
            if (zone == null || (player = Bukkit.getPlayer((UUID)playerId)) == null || !player.isOnline() || (timeInZone = (System.currentTimeMillis() - this.playerTimeInZone.get(playerId)) / 1000L) < (long)zone.getGuaranteedInterval()) continue;
            this.executeReward(player, zone.getGuaranteedCommand());
            this.playerTimeInZone.put(playerId, System.currentTimeMillis());
            if (timeInZone < (long)zone.getChanceInterval() || !((random = new Random().nextDouble() * 100.0) <= zone.getChancePercentage())) continue;
            this.executeReward(player, zone.getChanceCommand());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You received a special reward for staying in the AFK zone!");
        }
    }

    private void executeReward(Player player, String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        String finalCommand = command.replace("%player%", player.getName());
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(String.valueOf(ChatColor.GOLD) + "AFK Zone Selector")) {
            event.setCancelled(true);
            Selection selection = this.playerSelections.getOrDefault(player.getUniqueId(), new Selection(this));
            this.playerSelections.put(player.getUniqueId(), selection);
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                selection.setCorner1(event.getClickedBlock().getLocation());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "First corner selected at " + this.formatLocation(selection.getCorner1()));
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                selection.setCorner2(event.getClickedBlock().getLocation());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Second corner selected at " + this.formatLocation(selection.getCorner2()));
            }
        }
    }

    private String formatLocation(Location loc) {
        return loc.getWorld().getName() + " (" + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + ")";
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        boolean foundZone = false;
        for (AfkZone zone : this.afkZones.values()) {
            if (!zone.isInZone(event.getTo())) continue;
            foundZone = true;
            if (zone.getName().equals(this.playersInZone.get(playerId))) break;
            this.playersInZone.put(playerId, zone.getName());
            this.playerTimeInZone.put(playerId, System.currentTimeMillis());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You entered the AFK zone: " + String.valueOf(ChatColor.YELLOW) + zone.getName());
            break;
        }
        if (!foundZone && this.playersInZone.containsKey(playerId)) {
            String oldZone = this.playersInZone.get(playerId);
            this.playersInZone.remove(playerId);
            this.playerTimeInZone.remove(playerId);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You left the AFK zone: " + String.valueOf(ChatColor.YELLOW) + oldZone);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (AfkZone zone : this.afkZones.values()) {
            if (!zone.isInZone(player.getLocation())) continue;
            this.playersInZone.put(player.getUniqueId(), zone.getName());
            this.playerTimeInZone.put(player.getUniqueId(), System.currentTimeMillis());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You are in the AFK zone: " + String.valueOf(ChatColor.YELLOW) + zone.getName());
            break;
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.playersInZone.remove(playerId);
        this.playerTimeInZone.remove(playerId);
        this.playerSelections.remove(playerId);
        this.afkWands.remove(playerId);
    }

    private ItemStack createAfkWand() {
        ItemStack wand = new ItemStack(Material.BLAZE_ROD);
        ItemMeta meta = wand.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "AFK Zone Selector");
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left click to select corner 1")));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Right click to select corner 2")));
        meta.setLore(lore);
        wand.setItemMeta(meta);
        return wand;
    }

    private class AfkWandCommand
    implements CommandExecutor {
        private AfkWandCommand() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("afkzonepro.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            ItemStack wand = AfkZonePro.this.createAfkWand();
            player.getInventory().addItem(new ItemStack[]{wand});
            AfkZonePro.this.afkWands.put(player.getUniqueId(), wand);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have received an AFK zone selector wand!");
            return true;
        }
    }

    private class AfkZoneProCommand
    implements CommandExecutor {
        private AfkZoneProCommand() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("afkzonepro.admin")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /afkzonepro create <name>");
                return true;
            }
            if (args[0].equalsIgnoreCase("create")) {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /afkzonepro create <name>");
                    return true;
                }
                String zoneName = args[1];
                Selection selection = AfkZonePro.this.playerSelections.get(player.getUniqueId());
                if (selection == null || !selection.isComplete()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Please select both corners using the AFK wand first!");
                    return true;
                }
                AfkZone zone = new AfkZone(AfkZonePro.this, zoneName, selection.getCorner1(), selection.getCorner2(), AfkZonePro.this.getConfig().getInt("default-settings.guaranteed-reward.interval", 3600), AfkZonePro.this.getConfig().getString("default-settings.guaranteed-reward.command", "give %player% diamond 1"), AfkZonePro.this.getConfig().getInt("default-settings.chance-reward.interval", 3600), AfkZonePro.this.getConfig().getDouble("default-settings.chance-reward.chance", 10.0), AfkZonePro.this.getConfig().getString("default-settings.chance-reward.command", "give %player% emerald 1"));
                AfkZonePro.this.afkZones.put(zoneName, zone);
                AfkZonePro.this.saveAfkZones();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "AFK zone " + String.valueOf(ChatColor.YELLOW) + zoneName + String.valueOf(ChatColor.GREEN) + " has been created!");
                return true;
            }
            if (args[0].equalsIgnoreCase("list")) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "AFK Zones:");
                for (String zoneName : AfkZonePro.this.afkZones.keySet()) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + zoneName);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("delete")) {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /afkzonepro delete <name>");
                    return true;
                }
                String zoneName = args[1];
                if (AfkZonePro.this.afkZones.containsKey(zoneName)) {
                    AfkZonePro.this.afkZones.remove(zoneName);
                    AfkZonePro.this.getConfig().set("zones." + zoneName, null);
                    AfkZonePro.this.saveConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "AFK zone " + String.valueOf(ChatColor.YELLOW) + zoneName + String.valueOf(ChatColor.GREEN) + " has been deleted!");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "AFK zone " + String.valueOf(ChatColor.YELLOW) + zoneName + String.valueOf(ChatColor.RED) + " does not exist!");
                }
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /afkzonepro create <name>, /afkzonepro list, or /afkzonepro delete <name>");
            return true;
        }
    }

    public class AfkZone {
        private String name;
        private Location corner1;
        private Location corner2;
        private int guaranteedInterval;
        private String guaranteedCommand;
        private int chanceInterval;
        private double chancePercentage;
        private String chanceCommand;

        public AfkZone(AfkZonePro this$0, String name, Location corner1, Location corner2, int guaranteedInterval, String guaranteedCommand, int chanceInterval, double chancePercentage, String chanceCommand) {
            this.name = name;
            this.corner1 = corner1;
            this.corner2 = corner2;
            this.guaranteedInterval = guaranteedInterval;
            this.guaranteedCommand = guaranteedCommand;
            this.chanceInterval = chanceInterval;
            this.chancePercentage = chancePercentage;
            this.chanceCommand = chanceCommand;
        }

        public boolean isInZone(Location location) {
            return location.getWorld().equals((Object)this.corner1.getWorld()) && location.getX() >= Math.min(this.corner1.getX(), this.corner2.getX()) && location.getX() <= Math.max(this.corner1.getX(), this.corner2.getX()) && location.getY() >= Math.min(this.corner1.getY(), this.corner2.getY()) && location.getY() <= Math.max(this.corner1.getY(), this.corner2.getY()) && location.getZ() >= Math.min(this.corner1.getZ(), this.corner2.getZ()) && location.getZ() <= Math.max(this.corner1.getZ(), this.corner2.getZ());
        }

        public String getName() {
            return this.name;
        }

        public Location getCorner1() {
            return this.corner1;
        }

        public Location getCorner2() {
            return this.corner2;
        }

        public int getGuaranteedInterval() {
            return this.guaranteedInterval;
        }

        public String getGuaranteedCommand() {
            return this.guaranteedCommand;
        }

        public int getChanceInterval() {
            return this.chanceInterval;
        }

        public double getChancePercentage() {
            return this.chancePercentage;
        }

        public String getChanceCommand() {
            return this.chanceCommand;
        }
    }

    public class Selection {
        private Location corner1;
        private Location corner2;

        public Selection(AfkZonePro this$0) {
        }

        public void setCorner1(Location location) {
            this.corner1 = location;
        }

        public void setCorner2(Location location) {
            this.corner2 = location;
        }

        public Location getCorner1() {
            return this.corner1;
        }

        public Location getCorner2() {
            return this.corner2;
        }

        public boolean isComplete() {
            return this.corner1 != null && this.corner2 != null;
        }
    }
}

