/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block;

import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.rk.railroadways.block.custom.BaseRailroadCrossingBell;
import net.rk.railroadways.block.custom.BritCrossingAlarmBlock;
import net.rk.railroadways.block.custom.BritRailwayLightsBlock;
import net.rk.railroadways.block.custom.CrossbuckBlock;
import net.rk.railroadways.block.custom.DualRailwayLightsBlock;
import net.rk.railroadways.block.custom.PurpleActivatorRailBlock;
import net.rk.railroadways.block.custom.PurpleDetectorRailBlock;
import net.rk.railroadways.block.custom.PurplePoweredRailBlock;
import net.rk.railroadways.block.custom.RailroadCrossingArmBlock;
import net.rk.railroadways.block.custom.RailroadCrossingCantilever;
import net.rk.railroadways.block.custom.RailroadCrossingCantileverLights;
import net.rk.railroadways.block.custom.RailroadCrossingLights;
import net.rk.railroadways.block.custom.RotatingBaseRailroadCrossingBell;
import net.rk.railroadways.block.custom.TriRailwayLightsBlock;
import net.rk.railroadways.item.TRRItems;
import net.rk.railroadways.util.TRRSound;
import net.rk.thingamajigs.xtras.TSoundEvent;

public class TRRBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"thingamajigsrailroadways");
    public static final DeferredBlock<Block> RAILROAD_CROSSING_ARM = TRRBlocks.register("railroad_crossing_arm", () -> new RailroadCrossingArmBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> CROSSBUCK = TRRBlocks.register("crossbuck", () -> new CrossbuckBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> RAILROAD_CROSSING_LIGHTS = TRRBlocks.register("railroad_crossing_lights", () -> new RailroadCrossingLights(BlockBehaviour.Properties.of().lightLevel(TRRBlocks.railroadLightsEmission(15))));
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_1 = TRRBlocks.register("railroad_crossing_ebell_type_one", () -> new BaseRailroadCrossingBell(BlockBehaviour.Properties.of(), true){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), (SoundEvent)TSoundEvent.EBELL_ONE.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
        }
    });
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_2 = TRRBlocks.register("railroad_crossing_ebell_type_two", () -> new BaseRailroadCrossingBell(BlockBehaviour.Properties.of(), true){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), (SoundEvent)TSoundEvent.EBELL_TWO.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.box((double)5.5, (double)6.0, (double)5.5, (double)10.5, (double)12.0, (double)10.5), Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
    });
    public static final DeferredBlock<Block> MECHANICAL_BELL_TYPE_1 = TRRBlocks.register("railroad_crossing_bell_type_one", () -> new RotatingBaseRailroadCrossingBell(BlockBehaviour.Properties.of(), false){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), (SoundEvent)TSoundEvent.MECH_BELL_ONE.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
        }
    });
    public static final DeferredBlock<Block> MECHANICAL_BELL_TYPE_2 = TRRBlocks.register("railroad_crossing_bell_type_two", () -> new RotatingBaseRailroadCrossingBell(BlockBehaviour.Properties.of(), false){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), (SoundEvent)TSoundEvent.MECH_BELL_TWO.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
        }
    });
    public static final DeferredBlock<Block> PURPLE_RAIL = TRRBlocks.register("purple_rail", () -> new RailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noCollission().strength(0.7f).sound(SoundType.METAL)){

        public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
            return 1.1f;
        }
    });
    public static final DeferredBlock<Block> PURPLE_POWERED_RAIL = TRRBlocks.register("purple_powered_rail", () -> new PurplePoweredRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noCollission().strength(0.7f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> PURPLE_ACTIVATOR_RAIL = TRRBlocks.register("purple_activator_rail", () -> new PurpleActivatorRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noCollission().strength(0.7f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> PURPLE_DETECTOR_RAIL = TRRBlocks.register("purple_detector_rail", () -> new PurpleDetectorRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noCollission().strength(0.7f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> BRITISH_RAILWAY_LIGHTS = TRRBlocks.register("british_railway_lights", () -> new BritRailwayLightsBlock(BlockBehaviour.Properties.of().lightLevel(TRRBlocks.railwayCrossingEmission(15))));
    public static final DeferredBlock<Block> BRITISH_RAILWAY_ALARM = TRRBlocks.register("british_railway_alarm", () -> new BritCrossingAlarmBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> TRI_RAILWAY_LIGHTS = TRRBlocks.register("tri_railway_lights", () -> new TriRailwayLightsBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> DUAL_RAILWAY_LIGHTS = TRRBlocks.register("dual_railway_lights", () -> new DualRailwayLightsBlock(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_3 = TRRBlocks.register("railroad_crossing_ebell_type_three", () -> new BaseRailroadCrossingBell(BlockBehaviour.Properties.of(), 20){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), TRRSound.EBELL_THREE.get(), SoundSource.BLOCKS, 0.25f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
    });
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_4 = TRRBlocks.register("railroad_crossing_ebell_type_four", () -> new RotatingBaseRailroadCrossingBell(BlockBehaviour.Properties.of(), 10){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), TRRSound.EBELL_FOUR.get(), SoundSource.BLOCKS, 0.25f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0);
        }
    });
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER = TRRBlocks.register("railroad_crossing_cantilever", () -> new RailroadCrossingCantilever(BlockBehaviour.Properties.of()));
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_END = TRRBlocks.register("railroad_crossing_cantilever_end", () -> new RailroadCrossingCantilever(BlockBehaviour.Properties.of()){

        @Override
        public VoxelShape getCollisionShape(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
            switch ((Direction)bs.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_END;
                }
                case SOUTH: {
                    return SOUTH_END;
                }
                case EAST: {
                    return EAST_END;
                }
                case WEST: {
                    return WEST_END;
                }
            }
            return Shapes.block();
        }

        @Override
        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            if (context.isHoldingItem(RAILROAD_CROSSING_CANTILEVER.asItem())) {
                return Shapes.block();
            }
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_END;
                }
                case SOUTH: {
                    return SOUTH_END;
                }
                case EAST: {
                    return EAST_END;
                }
                case WEST: {
                    return WEST_END;
                }
            }
            return Shapes.block();
        }

        @Override
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigsrailroadways.railroad_crossing_cantilever_end.desc").withStyle(ChatFormatting.GRAY));
        }
    });
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_LIGHTS = TRRBlocks.register("railroad_crossing_cantilever_lights", () -> new RailroadCrossingCantileverLights(BlockBehaviour.Properties.of()));

    private static DeferredBlock<Block> register(String name, Supplier<Block> block) {
        DeferredBlock blk = BLOCKS.register(name, block);
        DeferredItem itm = TRRItems.ITEMS.register(name, () -> new BlockItem((Block)blk.get(), new Item.Properties()));
        return blk;
    }

    private static DeferredBlock<Block> registerBlockWithoutItem(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    private static boolean always(BlockState bs, BlockGetter bg, BlockPos bp) {
        return true;
    }

    private static boolean never(BlockState bs, BlockGetter bg, BlockPos bp) {
        return false;
    }

    private static ToIntFunction<BlockState> customLitBlockEmission(int lv) {
        return properties -> (Boolean)properties.getValue((Property)BlockStateProperties.LIT) != false ? lv : 0;
    }

    private static ToIntFunction<BlockState> enabledLitBlockEmission(int i) {
        return properties -> (Boolean)properties.getValue((Property)BlockStateProperties.ENABLED) != false ? i : 0;
    }

    private static ToIntFunction<BlockState> railroadLightsEmission(int i) {
        return properties -> (Boolean)properties.getValue((Property)RailroadCrossingLights.POWERED) != false ? i : 0;
    }

    private static ToIntFunction<BlockState> railwayCrossingEmission(int i) {
        return properties -> (Boolean)properties.getValue((Property)BritRailwayLightsBlock.POWERED) != false ? i : 0;
    }
}

