/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.rk.railroadways.block.custom.RailroadCrossingCantilever;
import net.rk.railroadways.entity.blockentity.TRRBlockEntity;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingCantLightsBE;
import net.rk.railroadways.menu.RRCantLightsMenu;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import org.jetbrains.annotations.Nullable;

public class RailroadCrossingCantileverLights
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<RailroadCrossingCantileverLights> CODEC = RailroadCrossingCantileverLights.simpleCodec(RailroadCrossingCantileverLights::new);

    public RailroadCrossingCantileverLights(BlockBehaviour.Properties properties) {
        super(properties.strength(1.1f, 10.0f).noOcclusion().pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }

    public VoxelShape getCollisionShape(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
        if (bs.getValue((Property)FACING) == Direction.NORTH || bs.getValue((Property)FACING) == Direction.SOUTH) {
            return RailroadCrossingCantilever.NORTH_SOUTH;
        }
        return RailroadCrossingCantilever.EAST_WEST;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return RailroadCrossingCantilever.NORTH_SOUTH;
        }
        return RailroadCrossingCantilever.EAST_WEST;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }

    public boolean propagatesSkylightDown(BlockState bs, BlockGetter bg, BlockPos bp) {
        return true;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RailroadCrossingCantLightsBE(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level lvl, BlockState bs, BlockEntityType<T> bet) {
        return RailroadCrossingCantileverLights.createTickerHelper(bet, TRRBlockEntity.RR_CANTILEVER_LIGHTS_BE.get(), (BlockEntityTicker)(lvl.isClientSide ? RailroadCrossingCantLightsBE::clientTick : RailroadCrossingCantLightsBE::serverTick));
    }

    public boolean isSignalSource(BlockState bs) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return false;
    }

    public int getSignal(BlockState bs, BlockGetter bg, BlockPos bp, Direction dir) {
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
        level.scheduleTick(pos.above(), level.getBlockState(pos.above()).getBlock(), 2, TickPriority.VERY_LOW);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigsrailroadways.railroad_crossing_cantilever_lights.desc").withStyle(ChatFormatting.GRAY));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, final BlockPos pos, Player player, BlockHitResult hitResult) {
        try {
            if (player instanceof ServerPlayer) {
                player.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.thingamajigsrailroadways.rr_lights.title").withStyle(ChatFormatting.WHITE);
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        return new RRCantLightsMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                    }
                }, pos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("TRailroadways Exception caught in Railroad Crossing Lights! Err: " + e.getMessage());
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

