/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.rk.railroadways.datagen.TRRBlockModel;
import net.rk.railroadways.datagen.TRRBlockTag;
import net.rk.railroadways.datagen.TRRItemModel;
import net.rk.railroadways.datagen.TRRItemTag;
import net.rk.railroadways.datagen.TRRLoot;
import net.rk.railroadways.datagen.TRRRecipe;

@EventBusSubscriber(modid="thingamajigsrailroadways", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new TRRBlockModel(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new TRRItemModel(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TRRLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        TRRBlockTag blockTags = new TRRBlockTag(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new TRRItemTag(packOutput, lookupProvider, blockTags.contentsGetter(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new TRRRecipe(packOutput, lookupProvider));
    }
}

