/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.entity.blockentity.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.rk.railroadways.entity.blockentity.TRRBlockEntity;
import org.jetbrains.annotations.Nullable;

public class DynamicSignBE
extends BlockEntity {
    BlockPos bp;
    public float yAngle = 0.0f;
    public int ticks;
    public final List<String> locs = List.of("thingamajigsrailroadways:textures/entity/signs/sign_aust_alt.png", "thingamajigsrailroadways:textures/entity/signs/sign_aust.png", "thingamajigsrailroadways:textures/entity/signs/sign_canadian.png", "thingamajigsrailroadways:textures/entity/signs/sign_cateye.png", "thingamajigsrailroadways:textures/entity/signs/sign_czech.png", "thingamajigsrailroadways:textures/entity/signs/sign_finnish.png", "thingamajigsrailroadways:textures/entity/signs/sign_german_horz.png", "thingamajigsrailroadways:textures/entity/signs/sign_german_vert.png", "thingamajigsrailroadways:textures/entity/signs/sign_inverted_cateye.png", "thingamajigsrailroadways:textures/entity/signs/sign_japan.png", "thingamajigsrailroadways:textures/entity/signs/sign_usa_crossbuck.png", "thingamajigsrailroadways:textures/entity/signs/sign_rr_ahead.png", "thingamajigsrailroadways:textures/entity/signs/sign_rr_ahead_old.png", "thingamajigsrailroadways:textures/entity/signs/sign_swrls.png");
    public int signType = 0;
    public String signOverrideLoc = this.locs.get(this.signType);
    public boolean customSign = false;

    public DynamicSignBE(BlockPos pos, BlockState blockState) {
        super(TRRBlockEntity.DYNAMIC_SIGN_BE.get(), pos, blockState);
        this.bp = pos;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lp) {
        CompoundTag ct = new CompoundTag();
        this.saveAdditional(ct, lp);
        return ct;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }

    public void updateBlock() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState bs2 = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), bs2, bs2, 3);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider slp) {
        super.saveAdditional(pTag, slp);
        pTag.putFloat("y_angle", this.yAngle);
        pTag.putString("sign_override_loc", this.signOverrideLoc);
        pTag.putInt("sign_type", this.signType);
        pTag.putBoolean("custom_sign", this.customSign);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider lp) {
        this.yAngle = pTag.getFloat("y_angle");
        this.signOverrideLoc = pTag.getString("sign_override_loc");
        this.signType = pTag.getInt("sign_type");
        this.customSign = pTag.getBoolean("custom_sign");
    }

    public static void serverTick(Level slvl, BlockPos sbp, BlockState sbs, DynamicSignBE rrcbe) {
        ++rrcbe.ticks;
        if (!rrcbe.customSign) {
            if (rrcbe.signType > rrcbe.locs.size() - 1) {
                rrcbe.signType = rrcbe.locs.size() - 1;
            } else {
                rrcbe.signOverrideLoc = rrcbe.locs.get(rrcbe.signType);
            }
        }
        if (rrcbe.ticks >= Short.MAX_VALUE) {
            rrcbe.ticks = 0;
        }
    }

    public static void clientTick(Level lvl, BlockPos bp, BlockState bs, DynamicSignBE rrcbe) {
        ++rrcbe.ticks;
        if (rrcbe.ticks >= Short.MAX_VALUE) {
            rrcbe.ticks = 0;
        }
    }
}

