/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.entity.blockentity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingBE;

public class RRArmModel
extends Model {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/rr_arm.png"), "main");
    private final ModelPart main;
    private final ModelPart gate;
    private final ModelPart barrier;

    public RRArmModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.main = root.getChild("base");
        this.gate = this.main.getChild("gate");
        this.barrier = this.gate.getChild("barrier");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(20, 24).addBox(-1.0f, -8.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, 7.0f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 12).addBox(-3.0f, 5.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 24).addBox(-2.0f, 4.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition gate = base.addOrReplaceChild("gate", CubeListBuilder.create().texOffs(0, 24).addBox(-4.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-6.0f, -1.0f, -2.0f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(4.0f, -1.0f, -2.0f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(3.0f, -1.0f, -6.0f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 38).addBox(-4.0f, -1.0f, -6.0f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition cube_r1 = gate.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 38).addBox(-0.5f, -1.2f, -5.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)0.0f, (float)-5.5f, (float)0.0f, (float)-0.6545f, (float)0.0f));
        PartDefinition cube_r2 = gate.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 38).addBox(-0.5f, -1.15f, -5.5f, 1.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)-5.5f, (float)0.0f, (float)0.6545f, (float)0.0f));
        PartDefinition barrier = gate.addOrReplaceChild("barrier", CubeListBuilder.create().texOffs(55, 53).addBox(-0.5f, -1.1f, -9.0f, 1.0f, 2.0f, -10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(RailroadCrossingBE rcbe) {
        this.barrier.zScale = rcbe.armLength;
        this.barrier.z = rcbe.armGateOffsetZ;
        this.main.yRot = rcbe.yAngle;
        this.gate.xRot = rcbe.armAngle * -1.0f;
        this.main.zRot = 0.0f;
        this.main.xRot = 3.1455512f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.main.render(poseStack, vertexConsumer, i, i1, i2);
    }

    public ModelPart getBarrier() {
        return this.barrier;
    }

    public ModelPart getGate() {
        return this.gate;
    }

    public ModelPart getMain() {
        return this.main;
    }
}

