/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.network.packet;

import java.util.logging.Logger;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.rk.railroadways.entity.blockentity.custom.DynamicSignBE;
import net.rk.railroadways.network.record.DynamicSignPayload;

public class DynamicSignPacket {
    public static final DynamicSignPacket INSTANCE = new DynamicSignPacket();

    public static DynamicSignPacket get() {
        return INSTANCE;
    }

    public void handle(DynamicSignPayload payload, IPayloadContext context) {
        Player ply = context.player();
        Level lvl = ply.level();
        if (ply == null) {
            return;
        }
        if (!lvl.hasChunk(SectionPos.blockToSectionCoord((int)payload.bp().getX()), SectionPos.blockToSectionCoord((int)payload.bp().getZ()))) {
            return;
        }
        DynamicSignBE dsbe = (DynamicSignBE)lvl.getBlockEntity(payload.bp());
        if (dsbe == null) {
            Logger.getAnonymousLogger().warning("Dynamic Sign BE at: " + String.valueOf(payload.bp()) + " is null! This is not normal!");
            return;
        }
        if (payload.updateSelf()) {
            dsbe.updateBlock();
        } else {
            dsbe.yAngle = payload.rotation();
            int tempA = payload.sign_type();
            if (tempA > dsbe.locs.size() - 1) {
                tempA = dsbe.locs.size() - 1;
            } else if (tempA < 0) {
                tempA = 0;
            } else {
                dsbe.signType = tempA;
            }
            dsbe.updateBlock();
        }
    }
}

