/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rk.railroadways.entity.blockentity.custom.DynamicSignBE;
import net.rk.railroadways.entity.blockentity.model.DynamicSignModel;

public class DynamicSignBERenderer
implements BlockEntityRenderer<DynamicSignBE> {
    public DynamicSignModel dsmodel;

    public DynamicSignBERenderer(BlockEntityRendererProvider.Context ctx) {
        this.dsmodel = new DynamicSignModel(ctx.bakeLayer(DynamicSignModel.SIGN_TEXTURE_LOCATION));
    }

    public void render(DynamicSignBE dynamicSignBE, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        VertexConsumer vc = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)dynamicSignBE.signOverrideLoc)));
        poseStack.pushPose();
        poseStack.translate(0.5f, -0.5f, 0.5f);
        this.dsmodel.setupAnim(dynamicSignBE);
        this.dsmodel.renderToBuffer(poseStack, vc, i, i1);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 32;
    }

    public AABB getRenderBoundingBox(DynamicSignBE blockEntity) {
        return new AABB((double)(blockEntity.getBlockPos().getX() - 1), (double)blockEntity.getBlockPos().getY(), (double)(blockEntity.getBlockPos().getZ() - 1), (double)(blockEntity.getBlockPos().getX() + 1), (double)(blockEntity.getBlockPos().getY() + 1), (double)(blockEntity.getBlockPos().getZ() + 1));
    }

    public boolean shouldRender(DynamicSignBE be, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec3.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public boolean shouldRenderOffScreen(DynamicSignBE blockEntity) {
        return false;
    }
}

