/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import net.rk.thingamajigs.datagen.TTag;

public class BaseRailroadCrossingBell
extends Block {
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public static final int MECHANICAL_BELL_SPEED = 10;
    public static final int ELECTRONIC_BELL_SPEED = 12;
    public int bellSpeed = 10;
    public boolean isElectronic = false;

    public BaseRailroadCrossingBell(BlockBehaviour.Properties p) {
        super(p.strength(1.0f, 10.0f).sound(SoundType.LANTERN).noOcclusion().noCollission());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BaseRailroadCrossingBell(BlockBehaviour.Properties p, boolean electronicType) {
        super(p.strength(1.0f, 10.0f).sound(SoundType.LANTERN).noOcclusion().noCollission());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.isElectronic = electronicType;
        this.bellSpeed = this.isElectronic ? 12 : 10;
    }

    public BaseRailroadCrossingBell(BlockBehaviour.Properties p, int customBellSpeed) {
        super(p.strength(1.0f, 10.0f).sound(SoundType.LANTERN).noOcclusion().noCollission());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.isElectronic = true;
        this.bellSpeed = customBellSpeed;
    }

    public boolean propagatesSkylightDown(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public int getSignal(BlockState bs, BlockGetter bg, BlockPos bp, Direction dir) {
        return (Boolean)bs.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk, BlockPos bp2, boolean p_55671_) {
        if (!lvl.isClientSide) {
            boolean allverticalredstoneblocks = lvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            boolean allrrbells = lvl.getBlockState(bp.below()).is(TTag.RAILROAD_CROSSING_BELLS);
            if (!allrrbells && allverticalredstoneblocks) {
                if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
    }

    public void tick(BlockState bs, ServerLevel slvl, BlockPos bp, RandomSource rs) {
        if (!slvl.isClientSide && ((Boolean)bs.getValue((Property)POWERED)).booleanValue()) {
            boolean allverticalredstoneblocks = slvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            if (!allverticalredstoneblocks) {
                slvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                return;
            }
            this.attemptPlaySound((Level)slvl, bp);
            slvl.scheduleTick(bp, bs.getBlock(), this.bellSpeed, TickPriority.LOW);
        }
    }

    public void onPlace(BlockState bs, Level lvl, BlockPos bp, BlockState bsOri, boolean bo1) {
        if (!lvl.isClientSide()) {
            lvl.scheduleTick(bp, bs.getBlock(), this.bellSpeed, TickPriority.LOW);
        }
    }

    public boolean attemptPlaySound(Level lp, BlockPos bp) {
        if (!lp.isClientSide) {
            lp.playSound(null, bp, SoundEvents.SHEEP_AMBIENT, SoundSource.BLOCKS, 0.75f, 1.0f);
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.rr_bell.desc").withStyle(ChatFormatting.GRAY));
    }
}

