/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import java.util.logging.Logger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.rk.railroadways.entity.blockentity.TRRBlockEntity;
import net.rk.railroadways.entity.blockentity.custom.BritRailwayLightsBE;
import net.rk.railroadways.menu.BritLightsMenu;
import net.rk.thingamajigs.block.TBlocks;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import net.rk.thingamajigs.datagen.TTag;
import org.jetbrains.annotations.Nullable;

public class BritRailwayLightsBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public static final MapCodec<BritRailwayLightsBlock> CODEC = BritRailwayLightsBlock.simpleCodec(BritRailwayLightsBlock::new);

    public BritRailwayLightsBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().sound(SoundType.LANTERN).pushReaction(PushReaction.BLOCK).strength(1.0f, 50.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BritRailwayLightsBE(blockPos, blockState);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void tick(BlockState bs, ServerLevel sl, BlockPos bp, RandomSource rs) {
        sl.updateNeighborsAt(bp.above(), (Block)this);
    }

    public void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk, BlockPos bp2, boolean p_55671_) {
        if (!lvl.isClientSide) {
            boolean allverticalredstoneblocks = lvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            boolean allrrbells = lvl.getBlockState(bp.below()).is(TTag.RAILROAD_CROSSING_BELLS);
            boolean allrrbellsabove = lvl.getBlockState(bp.above()).is(TTag.RAILROAD_CROSSING_BELLS);
            if (allrrbellsabove) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
                return;
            }
            if (lvl.getBlockState(bp.above()).is(TTag.RR_CANTILEVERS)) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else if (lvl.getBlockState(bp.below()).is((Block)TBlocks.CROSSWALK_BUTTON.get())) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
                return;
            }
            if (!allrrbells) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else if (lvl.hasNeighborSignal(bp)) {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    lvl.scheduleTick(bp.above(), (Block)this, 3, TickPriority.LOW);
                } else if (!lvl.hasNeighborSignal(bp)) {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    lvl.scheduleTick(bp.above(), (Block)this, 3, TickPriority.LOW);
                }
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level lvl, BlockState bs, BlockEntityType<T> bet) {
        return BritRailwayLightsBlock.createTickerHelper(bet, TRRBlockEntity.BRIT_RR_LIGHTS_BE.get(), (BlockEntityTicker)(lvl.isClientSide ? BritRailwayLightsBE::clientTick : BritRailwayLightsBE::serverTick));
    }

    public RenderShape getRenderShape(BlockState bs) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, final BlockPos pos, Player player, BlockHitResult hitResult) {
        try {
            if (player instanceof ServerPlayer) {
                player.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.thingamajigsrailroadways.railway_lights.title").withStyle(ChatFormatting.WHITE);
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        return new BritLightsMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                    }
                }, pos);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("TRailroadways Exception caught in Brit Railway Lights Block! Err: " + e.getMessage());
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

