/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingBE;
import net.rk.railroadways.entity.blockentity.model.RRArmModel;

public class RailroadCrossingArmBERenderer
implements BlockEntityRenderer<RailroadCrossingBE> {
    private RRArmModel model;

    public RailroadCrossingArmBERenderer(BlockEntityRendererProvider.Context berpContext) {
        this.model = new RRArmModel(berpContext.bakeLayer(RRArmModel.LAYER_LOCATION));
    }

    public void render(RailroadCrossingBE railroadCrossingBE, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.translate(0.5f, -0.5f, 0.5f);
        this.model.setupAnim(railroadCrossingBE);
        this.model.renderToBuffer(poseStack, multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)RRArmModel.LAYER_LOCATION.getModel())), i, i1);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(RailroadCrossingBE blockEntity) {
        int additionalamt = 5;
        return new AABB((double)((float)blockEntity.getBlockPos().getX() - blockEntity.armLength / 2.0f - (float)additionalamt), (double)(blockEntity.getBlockPos().getY() - 2), (double)((float)blockEntity.getBlockPos().getZ() - blockEntity.armLength / 2.0f - (float)additionalamt), (double)((float)blockEntity.getBlockPos().getX() + blockEntity.armLength / 2.0f + (float)additionalamt), (double)(blockEntity.getBlockPos().getY() + additionalamt), (double)((float)blockEntity.getBlockPos().getZ() + blockEntity.armLength / 2.0f + (float)additionalamt));
    }

    public boolean shouldRender(RailroadCrossingBE be, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(2.0, 2.0, 2.0).closerThan((Position)vec3.multiply(2.0, 2.0, 2.0), (double)this.getViewDistance());
    }

    public int getViewDistance() {
        return 54;
    }

    public boolean shouldRenderOffScreen(RailroadCrossingBE blockEntity) {
        return true;
    }
}

