/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.rk.railroadways.block.TRRBlocks;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import net.rk.thingamajigs.datagen.TTag;

public class PoleCap
extends Block {
    public static VoxelShape ALL = Shapes.join((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), (VoxelShape)Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), (BooleanOp)BooleanOp.OR);
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public int bellSpeed = 32;

    public PoleCap(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_LIGHT_GRAY).sound(SoundType.LANTERN).strength(1.0f, 5.0f).noOcclusion());
        this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ALL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context.isHoldingItem(TRRBlocks.POLE_CAP.asItem())) {
            return Shapes.block();
        }
        return ALL;
    }

    public boolean propagatesSkylightDown(BlockState bs, BlockGetter bg, BlockPos bp) {
        return true;
    }

    public int getSignal(BlockState bs, BlockGetter bg, BlockPos bp, Direction dir) {
        return (Boolean)bs.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk, BlockPos bp2, boolean p_55671_) {
        if (!lvl.isClientSide) {
            boolean allverticalredstoneblocks = lvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            boolean allrrbells = lvl.getBlockState(bp.below()).is(TTag.RAILROAD_CROSSING_BELLS);
            boolean isCant = lvl.getBlockState(bp.below()).is(TTag.RR_CANTILEVERS);
            if (!allrrbells) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    return;
                }
                if (isCant) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    return;
                }
            }
        }
    }

    public void tick(BlockState bs, ServerLevel slvl, BlockPos bp, RandomSource rs) {
        if (!slvl.isClientSide && ((Boolean)bs.getValue((Property)POWERED)).booleanValue()) {
            boolean both;
            boolean allverticalredstoneblocks = slvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            boolean isCant = slvl.getBlockState(bp.below()).is(TTag.RR_CANTILEVERS);
            boolean bl = both = allverticalredstoneblocks || isCant;
            if (!both) {
                slvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                return;
            }
            slvl.scheduleTick(bp, bs.getBlock(), this.bellSpeed, TickPriority.EXTREMELY_LOW);
        }
    }

    public void onPlace(BlockState bs, Level lvl, BlockPos bp, BlockState bsOri, boolean bo1) {
        if (!lvl.isClientSide()) {
            lvl.scheduleTick(bp, bs.getBlock(), this.bellSpeed, TickPriority.EXTREMELY_LOW);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }
}

