/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import net.rk.thingamajigs.datagen.TTag;
import org.jetbrains.annotations.Nullable;

public class RailroadCrossingCantilever
extends Block {
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape NORTH_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape EAST_WEST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORTH_END = Stream.of(Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)7.0, (double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)1.0), Block.box((double)7.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)7.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)7.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)7.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape EAST_END = Stream.of(Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)7.0, (double)16.0, (double)15.0, (double)8.0), Block.box((double)15.0, (double)15.0, (double)7.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)8.0), Block.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)7.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)1.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SOUTH_END = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)16.0), Block.box((double)8.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)15.0, (double)9.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)9.0, (double)16.0, (double)1.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)9.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape WEST_END = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)8.0), Block.box((double)0.0, (double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)9.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)9.0), Block.box((double)15.0, (double)1.0, (double)8.0, (double)16.0, (double)15.0, (double)9.0), Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)9.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RailroadCrossingCantilever(BlockBehaviour.Properties properties) {
        super(properties.strength(1.1f, 10.0f).noOcclusion().pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }

    public VoxelShape getCollisionShape(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
        if (bs.getValue((Property)FACING) == Direction.NORTH || bs.getValue((Property)FACING) == Direction.SOUTH) {
            return NORTH_SOUTH;
        }
        return EAST_WEST;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH) {
            return NORTH_SOUTH;
        }
        return EAST_WEST;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }

    public boolean propagatesSkylightDown(BlockState bs, BlockGetter bg, BlockPos bp) {
        return true;
    }

    public boolean isSignalSource(BlockState bs) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return false;
    }

    public int getSignal(BlockState bs, BlockGetter bg, BlockPos bp, Direction dir) {
        return 0;
    }

    public void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk, BlockPos bp2, boolean p_55671_) {
        Block redstone = Blocks.REDSTONE_WIRE.defaultBlockState().getBlock();
        if (!lvl.isClientSide) {
            boolean allverticalredstoneblocks = lvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            boolean allrrbells = lvl.getBlockState(bp.below()).is(TTag.RAILROAD_CROSSING_BELLS);
            boolean allrrbellsabove = lvl.getBlockState(bp.above()).is(TTag.RAILROAD_CROSSING_BELLS);
            if (allrrbellsabove) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
                return;
            }
            if (lvl.getBlockState(bp.above()).is(Blocks.REDSTONE_WIRE)) {
                lvl.scheduleTick(bp.above(), lvl.getBlockState(bp.above()).getBlock(), 2, TickPriority.LOW);
                return;
            }
        }
    }

    public void tick(BlockState bs, ServerLevel sl, BlockPos bp, RandomSource rs) {
        sl.updateNeighborsAt(bp.above(), (Block)this);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigsrailroadways.railroad_crossing_cantilever.desc").withStyle(ChatFormatting.GRAY));
    }
}

