/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.entity.blockentity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.rk.railroadways.entity.blockentity.TRRBlockEntity;
import org.jetbrains.annotations.Nullable;

public class RailroadCrossingCantLightsBE
extends BlockEntity {
    BlockPos bp;
    public float yAngle = 0.0f;
    public int ticks;
    public int maxTicksAllowed = Short.MAX_VALUE;
    private boolean hideOverride = false;
    public float frontLeftAngle = 0.0f;
    public float frontRightAngle = 0.0f;
    public float backLeftAngle = 0.0f;
    public float backRightAngle = 0.0f;
    public boolean showFrontLights = true;
    public boolean showBackLights = true;
    public boolean alternateFlashCycle = false;
    public int flasherTickDelay = 15;

    public boolean getFlashState() {
        return this.alternateFlashCycle;
    }

    public RailroadCrossingCantLightsBE(BlockPos pos, BlockState blockState) {
        super(TRRBlockEntity.RR_CANTILEVER_LIGHTS_BE.get(), pos, blockState);
        this.bp = pos;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lp) {
        CompoundTag ct = new CompoundTag();
        this.saveAdditional(ct, lp);
        return ct;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }

    public void updateBlock() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState bs2 = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), bs2, bs2, 3);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider slp) {
        super.saveAdditional(pTag, slp);
        pTag.putFloat("y_angle", this.yAngle);
        pTag.putFloat("front_left_angle", this.frontLeftAngle);
        pTag.putFloat("front_right_angle", this.frontRightAngle);
        pTag.putFloat("back_left_angle", this.backLeftAngle);
        pTag.putFloat("back_right_angle", this.backRightAngle);
        pTag.putBoolean("show_front_lights", this.showFrontLights);
        pTag.putBoolean("show_back_lights", this.showBackLights);
        pTag.putInt("flasher_tick_delay", this.flasherTickDelay);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider lp) {
        this.yAngle = pTag.getFloat("y_angle");
        this.frontLeftAngle = pTag.getFloat("front_left_angle");
        this.frontRightAngle = pTag.getFloat("front_right_angle");
        this.backLeftAngle = pTag.getFloat("back_left_angle");
        this.backRightAngle = pTag.getFloat("back_right_angle");
        this.showFrontLights = pTag.getBoolean("show_front_lights");
        this.showBackLights = pTag.getBoolean("show_back_lights");
        this.flasherTickDelay = pTag.getInt("flasher_tick_delay");
        if (this.flasherTickDelay <= 0) {
            this.flasherTickDelay = 15;
            this.updateBlock();
        }
    }

    public static void serverTick(Level slvl, BlockPos sbp, BlockState sbs, RailroadCrossingCantLightsBE rclbe) {
        ++rclbe.ticks;
        if (rclbe.ticks % rclbe.flasherTickDelay == 0) {
            boolean bl = rclbe.alternateFlashCycle = !rclbe.alternateFlashCycle;
        }
        if (rclbe.ticks >= rclbe.maxTicksAllowed) {
            rclbe.ticks = 0;
        }
    }

    public static void clientTick(Level lvl, BlockPos bp, BlockState bs, RailroadCrossingCantLightsBE rclbe) {
        ++rclbe.ticks;
        if (rclbe.ticks % rclbe.flasherTickDelay == 0) {
            rclbe.alternateFlashCycle = !rclbe.alternateFlashCycle;
        }
        rclbe.hideOverride = !lvl.hasNearbyAlivePlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 5.0);
        if (rclbe.ticks >= rclbe.maxTicksAllowed) {
            rclbe.ticks = 0;
        }
    }
}

