/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.network.packet;

import java.util.logging.Logger;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingCantLightsBE;
import net.rk.railroadways.network.record.RRCantLightsPayload;

public class RRCantLightsPacket {
    public static final RRCantLightsPacket INSTANCE = new RRCantLightsPacket();

    public static RRCantLightsPacket get() {
        return INSTANCE;
    }

    public void handle(RRCantLightsPayload payload, IPayloadContext context) {
        Player ply = context.player();
        Level lvl = ply.level();
        if (ply == null) {
            return;
        }
        if (!lvl.hasChunk(SectionPos.blockToSectionCoord((int)payload.bp().getX()), SectionPos.blockToSectionCoord((int)payload.bp().getZ()))) {
            return;
        }
        RailroadCrossingCantLightsBE rrclbe = (RailroadCrossingCantLightsBE)lvl.getBlockEntity(payload.bp());
        if (rrclbe == null) {
            Logger.getAnonymousLogger().warning("Railroad Crossing Lights BE at: " + String.valueOf(payload.bp()) + " is null! This is not normal!");
            return;
        }
        rrclbe.showFrontLights = payload.showFrontLights();
        rrclbe.showBackLights = payload.showBackLights();
        rrclbe.yAngle = payload.yAngle();
        rrclbe.frontLeftAngle = payload.frontLeftAngle();
        rrclbe.frontRightAngle = payload.frontRightAngle();
        rrclbe.backLeftAngle = payload.backLeftAngle();
        rrclbe.backRightAngle = payload.backRightAngle();
        rrclbe.updateBlock();
    }
}

