/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rk.railroadways.block.TRRBlocks;
import net.rk.railroadways.block.custom.RailroadCrossingLights;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingLightsBE;
import net.rk.railroadways.entity.blockentity.model.RRLightsBigModel;
import net.rk.railroadways.entity.blockentity.model.RRLightsModel;

public class RailroadCrossingLightsBERenderer
implements BlockEntityRenderer<RailroadCrossingLightsBE> {
    public RRLightsModel rrlightsmodel;
    public RRLightsBigModel rrLightsBigModel;
    private ResourceLocation lightsOff = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/lights_off.png");
    private ResourceLocation lightsOn0 = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/lights_on_0.png");
    private ResourceLocation lightsOn1 = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/lights_on_1.png");
    private ResourceLocation bigLightsOff = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/big_lights_off.png");
    private ResourceLocation bigLightsOn0 = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/big_lights_on_0.png");
    private ResourceLocation bigLightsOn1 = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/big_lights_on_1.png");

    public RailroadCrossingLightsBERenderer(BlockEntityRendererProvider.Context ctx) {
        this.rrlightsmodel = new RRLightsModel(ctx.bakeLayer(RRLightsModel.LIGHTS_TEXTURE_LOCATION));
        this.rrLightsBigModel = new RRLightsBigModel(ctx.bakeLayer(RRLightsBigModel.DEFAULT_TEXTURE));
    }

    public void render(RailroadCrossingLightsBE rrclbe, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        ResourceLocation tempLoc = rrclbe.getBlockState().is(TRRBlocks.BIG_RAILROAD_CROSSING_LIGHTS) ? this.bigLightsOff : this.lightsOff;
        if (((Boolean)rrclbe.getBlockState().getValue((Property)RailroadCrossingLights.POWERED)).booleanValue()) {
            tempLoc = rrclbe.getBlockState().is(TRRBlocks.BIG_RAILROAD_CROSSING_LIGHTS) ? (rrclbe.getFlashState() ? this.bigLightsOn0 : this.bigLightsOn1) : (rrclbe.getFlashState() ? this.lightsOn0 : this.lightsOn1);
        }
        VertexConsumer vc = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)tempLoc));
        if (rrclbe.getBlockState().is(TRRBlocks.BIG_RAILROAD_CROSSING_LIGHTS)) {
            this.rrLightsBigModel.setupAnim(rrclbe);
            this.rrLightsBigModel.renderToBuffer(poseStack, vc, i, i1);
        } else {
            this.rrlightsmodel.setupAnim(rrclbe);
            this.rrlightsmodel.renderToBuffer(poseStack, vc, i, i1);
        }
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 32;
    }

    public AABB getRenderBoundingBox(RailroadCrossingLightsBE blockEntity) {
        return new AABB((double)(blockEntity.getBlockPos().getX() - 1), (double)blockEntity.getBlockPos().getY(), (double)(blockEntity.getBlockPos().getZ() - 1), (double)(blockEntity.getBlockPos().getX() + 1), (double)(blockEntity.getBlockPos().getY() + 1), (double)(blockEntity.getBlockPos().getZ() + 1));
    }

    public boolean shouldRender(RailroadCrossingLightsBE be, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec3.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public boolean shouldRenderOffScreen(RailroadCrossingLightsBE blockEntity) {
        return false;
    }
}

