/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class PurpleActivatorRailBlock
extends BaseRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final MapCodec<PurpleActivatorRailBlock> CODEC = PurpleActivatorRailBlock.simpleCodec(PurpleActivatorRailBlock::new);

    public PurpleActivatorRailBlock(BlockBehaviour.Properties properties) {
        this(properties.noCollission(), false);
    }

    protected PurpleActivatorRailBlock(BlockBehaviour.Properties builder, boolean isPoweredRail) {
        super(true, builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigsrailroadways.purple_activator_rail.desc").withStyle(ChatFormatting.RED));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{SHAPE, POWERED, WATERLOGGED});
    }

    protected void updateState(BlockState bs, Level lvl, BlockPos bp, Block block1) {
        if (lvl.hasNeighborSignal(bp)) {
            lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(lvl.hasNeighborSignal(bp))), 3);
            lvl.updateNeighborsAt(bp.below(), (Block)this);
            if (((RailShape)bs.getValue(this.getShapeProperty())).isAscending()) {
                lvl.updateNeighborsAt(bp.above(), (Block)this);
            }
        }
    }

    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }

    public void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk1, BlockPos bp2, boolean bool1) {
        if (((Boolean)bs.getValue((Property)POWERED)).booleanValue() != lvl.hasNeighborSignal(bp)) {
            lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(lvl.hasNeighborSignal(bp))), 3);
            lvl.updateNeighborsAt(bp, (Block)this);
        }
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        List entityList;
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && level.getGameTime() % 200L == 0L && !cart.getPassengers().isEmpty() && (entityList = cart.getPassengers()).get(0) instanceof Monster) {
            ((Monster)entityList.get(0)).addEffect(new MobEffectInstance(MobEffects.WITHER, 1, 100));
            level.playSound(null, pos, SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.BLOCKS, 0.5f, 2.0f);
            ((Entity)entityList.get(0)).hurt(((Entity)entityList.get(0)).damageSources().magic(), 2.0f);
        }
    }

    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }
}

