/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.entity.blockentity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.rk.railroadways.block.custom.RailroadCrossingCantileverLights;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingCantLightsBE;

public class RRCantLightsModel
extends Model {
    private final ModelPart main;
    private final ModelPart lights_holder;
    public static final ModelLayerLocation CANT_LIGHTS_TEXTURE_LOCATION = new ModelLayerLocation(ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/rr_cantilever_off.png"), "main");
    private final ModelPart front_right;
    private final ModelPart front_left;
    private final ModelPart back_left;
    private final ModelPart back_right;

    public RRCantLightsModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.main = root.getChild("cantileverholder");
        this.lights_holder = this.main.getChild("lights");
        this.front_left = this.lights_holder.getChild("lightfrontleft");
        this.front_right = this.lights_holder.getChild("lightfrontright");
        this.back_left = this.lights_holder.getChild("lightbackleft");
        this.back_right = this.lights_holder.getChild("lightbackright");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition cantileverholder = partdefinition.addOrReplaceChild("cantileverholder", CubeListBuilder.create().texOffs(0, 5).addBox(-1.0f, -0.01f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 31).addBox(-8.0f, 7.0f, -8.0f, 16.0f, 1.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(7.0f, -7.0f, -8.0f, 1.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(48, 0).addBox(7.0f, -7.0f, 7.0f, 1.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(52, 0).addBox(-8.0f, -7.0f, 7.0f, 1.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(-8.0f, -7.0f, -8.0f, 1.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 23).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 25).addBox(-8.0f, -8.0f, 7.0f, 16.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition lights = cantileverholder.addOrReplaceChild("lights", CubeListBuilder.create().texOffs(0, 27).addBox(-8.0f, -1.0f, -1.0f, 16.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-2.0f, -1.0f, 1.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition lightfrontright = lights.addOrReplaceChild("lightfrontright", CubeListBuilder.create().texOffs(26, 1).addBox(-2.0f, -0.75f, -1.25f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(10, 15).addBox(-2.0f, -1.75f, -2.25f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)0.75f, (float)-2.75f));
        PartDefinition lightfrontleft = lights.addOrReplaceChild("lightfrontleft", CubeListBuilder.create().texOffs(26, 8).addBox(-2.0f, -0.75f, -1.25f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(10, 10).addBox(-2.0f, -1.75f, -2.25f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)0.75f, (float)-2.75f));
        PartDefinition lightbackright = lights.addOrReplaceChild("lightbackright", CubeListBuilder.create().texOffs(26, 15).addBox(-2.0f, -0.75f, -1.25f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(10, 5).addBox(-2.0f, -1.75f, -2.25f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)0.75f, (float)2.75f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lightbackleft = lights.addOrReplaceChild("lightbackleft", CubeListBuilder.create().texOffs(11, 20).addBox(-2.0f, -0.75f, -1.25f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(10, 0).addBox(-2.0f, -1.75f, -2.25f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)0.75f, (float)2.75f, (float)0.0f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(RailroadCrossingCantLightsBE rclbe) {
        this.front_left.yRot = rclbe.frontLeftAngle;
        this.front_right.yRot = rclbe.frontRightAngle;
        this.back_left.yRot = rclbe.backLeftAngle;
        this.back_right.yRot = rclbe.backRightAngle;
        this.main.y = 8.0f;
        this.main.yRot = rclbe.getBlockState().getValue((Property)RailroadCrossingCantileverLights.FACING) == Direction.NORTH || rclbe.getBlockState().getValue((Property)RailroadCrossingCantileverLights.FACING) == Direction.SOUTH ? 0.0f : 1.57f;
        this.main.xRot = 3.1455512f;
        this.lights_holder.y = 0.0f;
        this.lights_holder.yRot = rclbe.yAngle;
        if (rclbe.showFrontLights) {
            this.front_left.visible = true;
            this.front_right.visible = true;
        } else {
            this.front_left.visible = false;
            this.front_right.visible = false;
        }
        if (rclbe.showBackLights) {
            this.back_left.visible = true;
            this.back_right.visible = true;
        } else {
            this.back_left.visible = false;
            this.back_right.visible = false;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.main.render(poseStack, vertexConsumer, i, i1);
    }
}

