/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.network.packet;

import java.util.logging.Logger;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingBE;
import net.rk.railroadways.network.record.RailroadCrossingArmPayload;

public class RailroadCrossingArmPacket {
    public static final RailroadCrossingArmPacket INSTANCE = new RailroadCrossingArmPacket();

    public static RailroadCrossingArmPacket get() {
        return INSTANCE;
    }

    public void handle(RailroadCrossingArmPayload payload, IPayloadContext context) {
        Player ply = context.player();
        Level lvl = ply.level();
        if (ply == null) {
            return;
        }
        if (!lvl.hasChunk(SectionPos.blockToSectionCoord((int)payload.bp().getX()), SectionPos.blockToSectionCoord((int)payload.bp().getZ()))) {
            return;
        }
        RailroadCrossingBE rcbe = (RailroadCrossingBE)lvl.getBlockEntity(payload.bp());
        if (rcbe == null) {
            Logger.getAnonymousLogger().warning("Railroad Crossing BE at: " + String.valueOf(payload.bp()) + " is null! This is not normal!");
            return;
        }
        rcbe.armLength = payload.gateLength();
        rcbe.yAngle = payload.rotation();
        rcbe.startingArmAngle = payload.startArmAngle();
        rcbe.endArmAngle = payload.endArmAngle();
        rcbe.armGateOffsetZ = payload.gateOffset();
        rcbe.updateBlock();
    }
}

