/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.rk.railroadways.entity.blockentity.custom.TriRailwayLightsBE;
import net.rk.railroadways.menu.TriLightsMenu;
import net.rk.railroadways.network.record.TriLightsPayload;
import net.rk.thingamajigs.screen.widget.RevertedButton;

public class TriLightsScreen
extends AbstractContainerScreen<TriLightsMenu> {
    private static final HashMap<String, Object> guistate = TriLightsMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private TriRailwayLightsBE trlbe;
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/gui/rrc_component_setup_bg.png");
    RevertedButton decRot;
    RevertedButton incRot;

    public TriLightsScreen(TriLightsMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
        int widthx = (this.width - this.imageWidth) / 2;
        int heighty = (this.height - this.imageHeight) / 2;
        this.trlbe = (TriRailwayLightsBE)this.world.getBlockEntity(new BlockPos(this.x, this.y, this.z));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, true);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        guiGraphics.blit(BG_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public void containerTick() {
        super.containerTick();
    }

    public void onClose() {
        super.onClose();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.getMinecraft().player.closeContainer();
            return true;
        }
        return false;
    }

    protected void init() {
        super.init();
        this.setupWidgets();
        this.addRenderableWidget((GuiEventListener)this.decRot);
        this.addRenderableWidget((GuiEventListener)this.incRot);
    }

    private void setupWidgets() {
        int horzLeftButtonPos = this.leftPos + 25;
        int topRowButtonY = this.topPos + 25;
        int spacingButtonWidth = 2;
        float lowPitch = 0.95f;
        float normalPitch = 1.0f;
        this.decRot = new RevertedButton(this, horzLeftButtonPos, topRowButtonY, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.dec_gate_rot"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new TriLightsPayload(new BlockPos(this.x, this.y, this.z), this.trlbe.yAngle - 0.05f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)lowPitch));
        }){};
        int horzRightButtonPos = this.decRot.getX() + this.decRot.getWidth() + spacingButtonWidth;
        this.incRot = new RevertedButton(this, horzRightButtonPos, topRowButtonY, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.inc_gate_rot"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new TriLightsPayload(new BlockPos(this.x, this.y, this.z), this.trlbe.yAngle + 0.05f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)normalPitch));
        }){};
    }
}

