/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block;

import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.rk.railroadways.block.custom.BaseRailroadCrossingBell;
import net.rk.railroadways.block.custom.BritCrossingAlarmBlock;
import net.rk.railroadways.block.custom.BritRailwayLightsBlock;
import net.rk.railroadways.block.custom.CrossbuckBlock;
import net.rk.railroadways.block.custom.DirectionalVerticalRedstonePole;
import net.rk.railroadways.block.custom.DualRailwayLightsBlock;
import net.rk.railroadways.block.custom.PoleCap;
import net.rk.railroadways.block.custom.PurpleActivatorRailBlock;
import net.rk.railroadways.block.custom.PurpleDetectorRailBlock;
import net.rk.railroadways.block.custom.PurplePoweredRailBlock;
import net.rk.railroadways.block.custom.RailroadCrossingArmBlock;
import net.rk.railroadways.block.custom.RailroadCrossingArmLightedBlock;
import net.rk.railroadways.block.custom.RailroadCrossingCantilever;
import net.rk.railroadways.block.custom.RailroadCrossingCantileverEnd;
import net.rk.railroadways.block.custom.RailroadCrossingCantileverLights;
import net.rk.railroadways.block.custom.RailroadCrossingLights;
import net.rk.railroadways.block.custom.RotatingBaseRailroadCrossingBell;
import net.rk.railroadways.block.custom.RotatingCrossbuckBlock;
import net.rk.railroadways.block.custom.TriRailwayLightsBlock;
import net.rk.railroadways.item.TRRItems;
import net.rk.railroadways.util.TRRSound;
import net.rk.thingamajigs.xtras.TSoundEvent;
import org.jetbrains.annotations.Nullable;

public class TRRBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"thingamajigsrailroadways");
    public static final DeferredBlock<Block> RAILROAD_CROSSING_ARM = TRRBlocks.register("railroad_crossing_arm", RailroadCrossingArmBlock::new);
    public static final DeferredBlock<Block> CROSSBUCK = TRRBlocks.register("crossbuck", CrossbuckBlock::new);
    public static final DeferredBlock<Block> RAILROAD_CROSSING_LIGHTS = TRRBlocks.register("railroad_crossing_lights", properties -> new RailroadCrossingLights(properties.lightLevel(TRRBlocks.railroadLightsEmission(15))));
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_1 = TRRBlocks.register("railroad_crossing_ebell_type_one", properties -> new BaseRailroadCrossingBell((BlockBehaviour.Properties)properties, true){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), TRRSound.NEW_EBELL_ONE.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
        }
    });
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_2 = TRRBlocks.register("railroad_crossing_ebell_type_two", properties -> new BaseRailroadCrossingBell((BlockBehaviour.Properties)properties, true){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), TRRSound.NEW_EBELL_TWO.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.box((double)5.5, (double)6.0, (double)5.5, (double)10.5, (double)12.0, (double)10.5), Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
    });
    public static final DeferredBlock<Block> MECHANICAL_BELL_TYPE_1 = TRRBlocks.register("railroad_crossing_bell_type_one", properties -> new RotatingBaseRailroadCrossingBell((BlockBehaviour.Properties)properties, false){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), (SoundEvent)TSoundEvent.MECH_BELL_ONE.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
        }
    });
    public static final DeferredBlock<Block> MECHANICAL_BELL_TYPE_2 = TRRBlocks.register("railroad_crossing_bell_type_two", properties -> new RotatingBaseRailroadCrossingBell((BlockBehaviour.Properties)properties, false){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), (SoundEvent)TSoundEvent.MECH_BELL_TWO.get(), SoundSource.BLOCKS, 0.35f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
        }
    });
    public static final DeferredBlock<Block> PURPLE_RAIL = TRRBlocks.register("purple_rail", properties -> new RailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"thingamajigsrailroadways:purple_rail"))).noCollission().strength(0.7f).sound(SoundType.METAL)){

        public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
            if (this.isFlexibleRail(state, (BlockGetter)level, pos)) {
                return 0.91f;
            }
            return 1.1f;
        }

        protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
            return true;
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigsrailroadways.purple_rail.desc").withStyle(ChatFormatting.GRAY));
        }

        protected void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block block1, @Nullable Orientation orientation, boolean bool1) {
            if (!lvl.isClientSide && lvl.getBlockState(bp).is((Block)this)) {
                RailShape railshape = this.getRailDirection(bs, (BlockGetter)lvl, bp, null);
                this.updateState(bs, lvl, bp, block1);
            }
        }
    });
    public static final DeferredBlock<Block> PURPLE_POWERED_RAIL = TRRBlocks.register("purple_powered_rail", properties -> new PurplePoweredRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"thingamajigsrailroadways:purple_powered_rail"))).noCollission().strength(0.7f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> PURPLE_ACTIVATOR_RAIL = TRRBlocks.register("purple_activator_rail", properties -> new PurpleActivatorRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"thingamajigsrailroadways:purple_activator_rail"))).noCollission().strength(0.7f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> PURPLE_DETECTOR_RAIL = TRRBlocks.register("purple_detector_rail", properties -> new PurpleDetectorRailBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"thingamajigsrailroadways:purple_detector_rail"))).noCollission().strength(0.7f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> BRITISH_RAILWAY_LIGHTS = TRRBlocks.register("british_railway_lights", properties -> new BritRailwayLightsBlock(properties.lightLevel(TRRBlocks.railwayCrossingEmission(15))));
    public static final DeferredBlock<Block> BRITISH_RAILWAY_ALARM = TRRBlocks.register("british_railway_alarm", BritCrossingAlarmBlock::new);
    public static final DeferredBlock<Block> TRI_RAILWAY_LIGHTS = TRRBlocks.register("tri_railway_lights", TriRailwayLightsBlock::new);
    public static final DeferredBlock<Block> DUAL_RAILWAY_LIGHTS = TRRBlocks.register("dual_railway_lights", DualRailwayLightsBlock::new);
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_3 = TRRBlocks.register("railroad_crossing_ebell_type_three", properties -> new BaseRailroadCrossingBell((BlockBehaviour.Properties)properties, 20){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), TRRSound.EBELL_THREE.get(), SoundSource.BLOCKS, 0.25f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Stream.of(Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.box((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
    });
    public static final DeferredBlock<Block> ELECTRONIC_BELL_TYPE_4 = TRRBlocks.register("railroad_crossing_ebell_type_four", properties -> new RotatingBaseRailroadCrossingBell((BlockBehaviour.Properties)properties, 10){

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSeededSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), TRRSound.EBELL_FOUR.get(), SoundSource.BLOCKS, 0.25f, 1.0f, lp.random.nextLong());
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0);
        }
    });
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER = TRRBlocks.register("railroad_crossing_cantilever", RailroadCrossingCantilever::new);
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_END = TRRBlocks.register("railroad_crossing_cantilever_end", RailroadCrossingCantileverEnd::new);
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_LIGHTS = TRRBlocks.register("railroad_crossing_cantilever_lights", RailroadCrossingCantileverLights::new);
    public static final DeferredBlock<Block> RAILROAD_CROSSING_ARM_LIGHTED = TRRBlocks.register("railroad_crossing_arm_lighted", RailroadCrossingArmLightedBlock::new);
    public static final DeferredBlock<Block> RR_LADDER_POLE = TRRBlocks.register("rr_ladder_pole", properties -> new DirectionalVerticalRedstonePole((BlockBehaviour.Properties)properties){
        public final VoxelShape NORTH = Stream.of(Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)12.0, (double)0.0, (double)6.0, (double)14.0, (double)7.0, (double)7.0), Block.box((double)2.0, (double)0.0, (double)6.0, (double)4.0, (double)7.0, (double)7.0), Block.box((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)6.0, (double)7.0), Block.box((double)12.0, (double)7.0, (double)6.0, (double)14.0, (double)16.0, (double)7.0), Block.box((double)2.0, (double)7.0, (double)6.0, (double)4.0, (double)16.0, (double)7.0), Block.box((double)4.0, (double)11.0, (double)6.0, (double)12.0, (double)13.0, (double)7.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        public final VoxelShape EAST = Stream.of(Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)9.0, (double)0.0, (double)12.0, (double)10.0, (double)7.0, (double)14.0), Block.box((double)9.0, (double)0.0, (double)2.0, (double)10.0, (double)7.0, (double)4.0), Block.box((double)9.0, (double)4.0, (double)4.0, (double)10.0, (double)6.0, (double)12.0), Block.box((double)9.0, (double)7.0, (double)12.0, (double)10.0, (double)16.0, (double)14.0), Block.box((double)9.0, (double)7.0, (double)2.0, (double)10.0, (double)16.0, (double)4.0), Block.box((double)9.0, (double)11.0, (double)4.0, (double)10.0, (double)13.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        public final VoxelShape SOUTH = Stream.of(Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)2.0, (double)0.0, (double)9.0, (double)4.0, (double)7.0, (double)10.0), Block.box((double)12.0, (double)0.0, (double)9.0, (double)14.0, (double)7.0, (double)10.0), Block.box((double)4.0, (double)4.0, (double)9.0, (double)12.0, (double)6.0, (double)10.0), Block.box((double)2.0, (double)7.0, (double)9.0, (double)4.0, (double)16.0, (double)10.0), Block.box((double)12.0, (double)7.0, (double)9.0, (double)14.0, (double)16.0, (double)10.0), Block.box((double)4.0, (double)11.0, (double)9.0, (double)12.0, (double)13.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        public final VoxelShape WEST = Stream.of(Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)6.0, (double)0.0, (double)2.0, (double)7.0, (double)7.0, (double)4.0), Block.box((double)6.0, (double)0.0, (double)12.0, (double)7.0, (double)7.0, (double)14.0), Block.box((double)6.0, (double)4.0, (double)4.0, (double)7.0, (double)6.0, (double)12.0), Block.box((double)6.0, (double)7.0, (double)2.0, (double)7.0, (double)16.0, (double)4.0), Block.box((double)6.0, (double)7.0, (double)12.0, (double)7.0, (double)16.0, (double)14.0), Block.box((double)6.0, (double)11.0, (double)4.0, (double)7.0, (double)13.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

        public VoxelShape getShape(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
            switch ((Direction)bs.getValue(DirectionalVerticalRedstonePole.FACING)) {
                case NORTH: {
                    return this.NORTH;
                }
                case SOUTH: {
                    return this.SOUTH;
                }
                case EAST: {
                    return this.EAST;
                }
                case WEST: {
                    return this.WEST;
                }
            }
            return Shapes.block();
        }
    });
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_END_LADDER = TRRBlocks.register("railroad_crossing_cantilever_end_ladder", RailroadCrossingCantileverEnd::new);
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_END_NO_POLE_LADDER = TRRBlocks.register("railroad_crossing_cantilever_end_no_pole_ladder", properties -> new RailroadCrossingCantileverEnd((BlockBehaviour.Properties)properties){

        @Override
        public VoxelShape getCollisionShape(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
            switch ((Direction)bs.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_NO_POLE_END;
                }
                case SOUTH: {
                    return SOUTH_NO_POLE_END;
                }
                case EAST: {
                    return EAST_NO_POLE_END;
                }
                case WEST: {
                    return WEST_NO_POLE_END;
                }
            }
            return Shapes.block();
        }

        @Override
        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            if (context.isHoldingItem(this.asItem())) {
                return Shapes.block();
            }
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_NO_POLE_END;
                }
                case SOUTH: {
                    return SOUTH_NO_POLE_END;
                }
                case EAST: {
                    return EAST_NO_POLE_END;
                }
                case WEST: {
                    return WEST_NO_POLE_END;
                }
            }
            return Shapes.block();
        }
    });
    public static final DeferredBlock<Block> RAILROAD_CROSSING_CANTILEVER_END_NO_POLE = TRRBlocks.register("railroad_crossing_cantilever_end_no_pole", properties -> new RailroadCrossingCantileverEnd((BlockBehaviour.Properties)properties){

        @Override
        public VoxelShape getCollisionShape(BlockState bs, BlockGetter bg, BlockPos bp, CollisionContext cc) {
            switch ((Direction)bs.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_NO_POLE_END;
                }
                case SOUTH: {
                    return SOUTH_NO_POLE_END;
                }
                case EAST: {
                    return EAST_NO_POLE_END;
                }
                case WEST: {
                    return WEST_NO_POLE_END;
                }
            }
            return Shapes.block();
        }

        @Override
        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            if (context.isHoldingItem(this.asItem())) {
                return Shapes.block();
            }
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    return NORTH_NO_POLE_END;
                }
                case SOUTH: {
                    return SOUTH_NO_POLE_END;
                }
                case EAST: {
                    return EAST_NO_POLE_END;
                }
                case WEST: {
                    return WEST_NO_POLE_END;
                }
            }
            return Shapes.block();
        }
    });
    public static final DeferredBlock<Block> POLE_CAP = TRRBlocks.register("pole_cap", PoleCap::new);
    public static final DeferredBlock<Block> BIG_RAILROAD_CROSSING_CANTILEVER_LIGHTS = TRRBlocks.register("big_railroad_crossing_cantilever_lights", RailroadCrossingCantileverLights::new);
    public static final DeferredBlock<Block> BIG_RAILROAD_CROSSING_LIGHTS = TRRBlocks.register("big_railroad_crossing_lights", properties -> new RailroadCrossingLights(properties.lightLevel(TRRBlocks.railroadLightsEmission(15))){

        @Override
        public RenderShape getRenderShape(BlockState bs) {
            return RenderShape.INVISIBLE;
        }
    });
    public static final DeferredBlock<Block> CLICKY_MECHANICAL_BELL = TRRBlocks.register("clicky_mechanical_bell", properties -> new RotatingBaseRailroadCrossingBell((BlockBehaviour.Properties)properties, 11){
        public static final VoxelShape ALL = Shapes.join((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), (VoxelShape)Block.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), (BooleanOp)BooleanOp.OR);

        @Override
        public boolean attemptPlaySound(Level lp, BlockPos bp) {
            if (!lp.isClientSide) {
                lp.playSound(null, bp, TRRSound.CLICKY_MECHANICAL_BELL.get(), SoundSource.BLOCKS, 0.95f, 1.0f);
                return true;
            }
            return false;
        }

        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return ALL;
        }
    });
    public static final DeferredBlock<Block> CROSSBUCK_WITH_LADDER = TRRBlocks.register("crossbuck_with_ladder", properties -> new RotatingCrossbuckBlock((BlockBehaviour.Properties)properties){

        @Override
        protected RenderShape getRenderShape(BlockState state) {
            return RenderShape.MODEL;
        }
    });

    public static <T extends Block> DeferredBlock<T> register(String name, Function<BlockBehaviour.Properties, T> function) {
        DeferredBlock block = BLOCKS.registerBlock(name, function);
        TRRBlocks.registerBlockItem(name, block);
        return block;
    }

    public static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        TRRItems.ITEMS.registerItem(name, properties -> new BlockItem((Block)block.get(), properties.useBlockDescriptionPrefix()));
    }

    private static ToIntFunction<BlockState> railroadLightsEmission(int i) {
        return properties -> (Boolean)properties.getValue((Property)RailroadCrossingLights.POWERED) != false ? i : 0;
    }

    private static ToIntFunction<BlockState> railwayCrossingEmission(int i) {
        return properties -> (Boolean)properties.getValue((Property)BritRailwayLightsBlock.POWERED) != false ? i : 0;
    }
}

