/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.rk.railroadways.block.TRRBlocks;
import net.rk.railroadways.entity.blockentity.TRRBlockEntity;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingBE;
import net.rk.railroadways.menu.RailroadCrossingArmMenu;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import org.jetbrains.annotations.Nullable;

public class RailroadCrossingArmBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public static final MapCodec<RailroadCrossingArmBlock> CODEC = RailroadCrossingArmBlock.simpleCodec(RailroadCrossingArmBlock::new);
    public static final VoxelShape ALL = Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RailroadCrossingArmBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().sound(SoundType.LANTERN).pushReaction(PushReaction.BLOCK).strength(1.0f, 50.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return context.isHoldingItem(TRRBlocks.RAILROAD_CROSSING_ARM.asItem()) ? Shapes.block() : ALL;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ALL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, final BlockPos pos, Player player, BlockHitResult hitResult) {
        try {
            if (player instanceof ServerPlayer) {
                player.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.thingamajigsrailroadways.rr_arm.title").withStyle(ChatFormatting.WHITE);
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        return new RailroadCrossingArmMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                    }
                }, pos);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("TRailroadways Exception caught in Railroad Crossing Arm Block! Err: " + e.getMessage());
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RailroadCrossingBE(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level lvl, BlockState bs, BlockEntityType<T> bet) {
        return RailroadCrossingArmBlock.createTickerHelper(bet, TRRBlockEntity.RAILROAD_CROSSING_ARM_BE.get(), (BlockEntityTicker)(lvl.isClientSide ? RailroadCrossingBE::clientTick : RailroadCrossingBE::serverTick));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk1, @Nullable Orientation ori, boolean bool1) {
        boolean flag;
        if (!lvl.isClientSide && (flag = ((Boolean)bs.getValue((Property)POWERED)).booleanValue()) != lvl.hasNeighborSignal(bp)) {
            if (flag) {
                lvl.scheduleTick(bp, (Block)this, 4);
            } else {
                lvl.setBlock(bp, (BlockState)bs.cycle((Property)POWERED), 2);
            }
        }
    }

    public void tick(BlockState bs, ServerLevel sl, BlockPos bp, RandomSource rs) {
        Block blk = sl.getBlockState(bp.above()).getBlock();
        boolean flag2 = sl.hasNeighborSignal(bp);
        if (flag2) {
            sl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            sl.scheduleTick(bp.above(), blk, 7, TickPriority.LOW);
        } else {
            sl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            sl.scheduleTick(bp.above(), blk, 7, TickPriority.LOW);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigsrailroadways.rr_arm.desc").withStyle(ChatFormatting.GRAY));
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.block();
    }
}

