/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.block.custom;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;
import net.rk.railroadways.entity.blockentity.TRRBlockEntity;
import net.rk.railroadways.entity.blockentity.custom.TriRailwayLightsBE;
import net.rk.railroadways.menu.TriLightsMenu;
import net.rk.thingamajigs.block.TBlocks;
import net.rk.thingamajigs.block.custom.VerticalPoleRedstone;
import net.rk.thingamajigs.datagen.TTag;
import org.jetbrains.annotations.Nullable;

public class TriRailwayLightsBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = VerticalPoleRedstone.POWERED;
    public static final MapCodec<TriRailwayLightsBlock> CODEC = TriRailwayLightsBlock.simpleCodec(TriRailwayLightsBlock::new);

    public TriRailwayLightsBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().sound(SoundType.LANTERN).pushReaction(PushReaction.BLOCK).strength(1.0f, 50.0f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TriRailwayLightsBE(blockPos, blockState);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> bs) {
        bs.add(new Property[]{POWERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void neighborChanged(BlockState bs, Level lvl, BlockPos bp, Block blk1, @Nullable Orientation ori1, boolean bool1) {
        if (!lvl.isClientSide) {
            boolean allverticalredstoneblocks = lvl.getBlockState(bp.below()).is(TTag.VERTICAL_REDSTONE_BLOCKS);
            boolean allrrbells = lvl.getBlockState(bp.below()).is(TTag.RAILROAD_CROSSING_BELLS);
            boolean allrrbellsabove = lvl.getBlockState(bp.above()).is(TTag.RAILROAD_CROSSING_BELLS);
            if (allrrbellsabove) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
                return;
            }
            if (lvl.getBlockState(bp.above()).is(TTag.RR_CANTILEVERS)) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else if (lvl.getBlockState(bp.below()).is((Block)TBlocks.CROSSWALK_BUTTON.get())) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                }
                return;
            }
            if (!allrrbells) {
                if (allverticalredstoneblocks) {
                    if (((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    } else if (!((Boolean)lvl.getBlockState(bp.below()).getValue((Property)POWERED)).booleanValue()) {
                        lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                } else if (lvl.hasNeighborSignal(bp)) {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                    lvl.scheduleTick(bp.above(), (Block)this, 3, TickPriority.LOW);
                } else if (!lvl.hasNeighborSignal(bp)) {
                    lvl.setBlock(bp, (BlockState)bs.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                    lvl.scheduleTick(bp.above(), (Block)this, 3, TickPriority.LOW);
                }
            }
        }
    }

    public void tick(BlockState bs, ServerLevel sl, BlockPos bp, RandomSource rs) {
        sl.updateNeighborsAt(bp.above(), (Block)this);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, final BlockPos pos, Player player, BlockHitResult hitResult) {
        try {
            if (player instanceof ServerPlayer) {
                player.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"container.thingamajigsrailroadways.railway_lights.title").withStyle(ChatFormatting.WHITE);
                    }

                    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                        return new TriLightsMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                    }
                }, pos);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().warning("TRailroadways Exception caught in Tri Railway Lights Block! Err: " + e.getMessage());
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level lvl, BlockState bs, BlockEntityType<T> bet) {
        return TriRailwayLightsBlock.createTickerHelper(bet, TRRBlockEntity.TRI_RR_LIGHTS_BE.get(), (BlockEntityTicker)(lvl.isClientSide ? TriRailwayLightsBE::clientTick : TriRailwayLightsBE::serverTick));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"block.thingamajigs.tri_railway_lights").withStyle(ChatFormatting.GRAY));
    }
}

