/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.rk.railroadways.datagen.TRRBlockTag;
import net.rk.railroadways.datagen.TRRItemTag;
import net.rk.railroadways.datagen.TRRLanguage;
import net.rk.railroadways.datagen.TRRLoot;
import net.rk.railroadways.datagen.TRRModelProvider;
import net.rk.railroadways.datagen.TRRRecipe;
import net.rk.railroadways.datagen.TRRSoundDefinition;

@EventBusSubscriber(modid="thingamajigsrailroadways")
public class TRRDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.getGenerator().addProvider(true, (DataProvider)new TRRModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TRRLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        TRRBlockTag blockTags = new TRRBlockTag(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new TRRItemTag(packOutput, lookupProvider, blockTags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new TRRRecipe.RecipeRunner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TRRLanguage(packOutput, "en_us"));
        generator.addProvider(true, (DataProvider)new TRRSoundDefinition(packOutput));
    }

    @SubscribeEvent
    public static void gatherDataServer(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.getGenerator().addProvider(true, (DataProvider)new TRRModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(TRRLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        TRRBlockTag blockTags = new TRRBlockTag(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTags);
        event.getGenerator().addProvider(true, (DataProvider)new TRRItemTag(packOutput, lookupProvider, blockTags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new TRRRecipe.RecipeRunner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TRRLanguage(packOutput, "en_us"));
        generator.addProvider(true, (DataProvider)new TRRSoundDefinition(packOutput));
    }
}

