/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.datagen;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.rk.railroadways.block.TRRBlocks;
import net.rk.railroadways.item.TRRItems;

public class TRRModelProvider
extends ModelProvider {
    public ItemModelGenerators gen;
    public BlockModelGenerators genBlock;

    public TRRModelProvider(PackOutput packOutput) {
        super(packOutput, "thingamajigsrailroadways");
    }

    public void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.gen = itemModels;
        this.genBlock = blockModels;
        this.genBlock.createPassiveRail((Block)TRRBlocks.PURPLE_RAIL.get());
        this.genBlock.createActiveRail((Block)TRRBlocks.PURPLE_ACTIVATOR_RAIL.get());
        this.genBlock.createActiveRail((Block)TRRBlocks.PURPLE_DETECTOR_RAIL.get());
        this.genBlock.createActiveRail((Block)TRRBlocks.PURPLE_POWERED_RAIL.get());
        itemModels.generateFlatItem(TRRBlocks.CROSSBUCK.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.RAILROAD_CROSSING_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.BRITISH_RAILWAY_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.DUAL_RAILWAY_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.TRI_RAILWAY_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.RAILROAD_CROSSING_CANTILEVER_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.RAILROAD_CROSSING_ARM_LIGHTED.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.BIG_RAILROAD_CROSSING_CANTILEVER_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.BIG_RAILROAD_CROSSING_LIGHTS.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(TRRBlocks.CROSSBUCK_WITH_LADDER.asItem(), ModelTemplates.FLAT_ITEM);
        this.customItemModel((Block)TRRBlocks.RR_LADDER_POLE.get(), "thingamajigsrailroadways:block/pole_rr_ladder");
        this.customItemModel((Block)TRRBlocks.RAILROAD_CROSSING_CANTILEVER_END_LADDER.get(), "thingamajigsrailroadways:block/rr_cantilever_end_ladder");
        this.customItemModel((Block)TRRBlocks.RAILROAD_CROSSING_CANTILEVER_END_NO_POLE.get(), "thingamajigsrailroadways:block/rr_cantilever_end_no_pole");
        this.customItemModel((Block)TRRBlocks.RAILROAD_CROSSING_CANTILEVER_END_NO_POLE_LADDER.get(), "thingamajigsrailroadways:block/rr_cantilever_end_no_pole_ladder");
        this.customItemModel((Block)TRRBlocks.POLE_CAP.get(), "thingamajigsrailroadways:block/pole_cap");
        this.customItemModel((Block)TRRBlocks.CLICKY_MECHANICAL_BELL.get(), "thingamajigsrailroadways:block/clicky_mechanical_bell");
    }

    protected Stream<? extends Holder<Item>> getKnownItems() {
        return TRRItems.ITEMS.getEntries().stream();
    }

    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        return TRRBlocks.BLOCKS.getEntries().stream().filter(x -> x.is(Blocks.AIR.builtInRegistryHolder().key()));
    }

    public void customItemModel(Block block, String customLocation) {
        ResourceLocation rs = ResourceLocation.parse((String)customLocation);
        this.gen.itemModelOutput.register(block.asItem(), new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(rs, Collections.emptyList()), new ClientItem.Properties(true)));
    }

    public void customItemModel(Block block) {
        this.gen.itemModelOutput.register(block.asItem(), new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)block.asItem()), Collections.emptyList()), new ClientItem.Properties(true)));
    }

    public void customItemModel(Item item) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Collections.emptyList()), new ClientItem.Properties(true)));
    }

    public void customItemModel(Item item, String customLocation) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ResourceLocation.parse((String)customLocation), Collections.emptyList()), new ClientItem.Properties(true)));
    }

    public void customItemModel(Item item, String customLocation, List<ItemTintSource> sources) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ResourceLocation.parse((String)customLocation), sources), new ClientItem.Properties(true)));
    }
}

