/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.rk.railroadways.block.custom.RailroadCrossingArmLightedBlock;
import net.rk.railroadways.entity.blockentity.custom.RailroadCrossingArmWithLights;
import net.rk.railroadways.entity.blockentity.model.RRArmLightsModel;

public class RailroadCrossingArmWithLightsRenderer
implements BlockEntityRenderer<RailroadCrossingArmWithLights> {
    private ResourceLocation noLight = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/railroad_arm_no_light.png");
    private ResourceLocation firstLight = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/railroad_arm_first_light.png");
    private ResourceLocation secondLight = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/entity/railroad_arm_second_light.png");
    private RRArmLightsModel model;

    public RailroadCrossingArmWithLightsRenderer(BlockEntityRendererProvider.Context berpContext) {
        this.model = new RRArmLightsModel(berpContext.bakeLayer(RRArmLightsModel.RAILROAD_CROSSING_ARM_WITH_LIGHTS));
    }

    public void render(RailroadCrossingArmWithLights railroadCrossingBE, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.translate(0.5f, -1.5f, 0.5f);
        ResourceLocation lightsOffTemp = this.noLight;
        VertexConsumer vc = multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)lightsOffTemp));
        if (((Boolean)railroadCrossingBE.getBlockState().getValue((Property)RailroadCrossingArmLightedBlock.POWERED)).booleanValue()) {
            vc = railroadCrossingBE.getFlashState() ? multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.firstLight)) : multiBufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.secondLight));
        }
        this.model.setupAnim(railroadCrossingBE);
        this.model.renderToBuffer(poseStack, vc, i, i1);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(RailroadCrossingArmWithLights blockEntity) {
        int additionalamt = 5;
        return new AABB((double)((float)blockEntity.getBlockPos().getX() - blockEntity.armLength / 2.0f - (float)additionalamt), (double)(blockEntity.getBlockPos().getY() - 2), (double)((float)blockEntity.getBlockPos().getZ() - blockEntity.armLength / 2.0f - (float)additionalamt), (double)((float)blockEntity.getBlockPos().getX() + blockEntity.armLength / 2.0f + (float)additionalamt), (double)(blockEntity.getBlockPos().getY() + additionalamt), (double)((float)blockEntity.getBlockPos().getZ() + blockEntity.armLength / 2.0f + (float)additionalamt));
    }

    public boolean shouldRender(RailroadCrossingArmWithLights be, Vec3 vec3) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(2.0, 2.0, 2.0).closerThan((Position)vec3.multiply(2.0, 2.0, 2.0), (double)this.getViewDistance());
    }

    public int getViewDistance() {
        return 54;
    }

    public boolean shouldRenderOffScreen(RailroadCrossingArmWithLights blockEntity) {
        return true;
    }
}

