/*
 * Decompiled with CFR 0.152.
 */
package net.rk.railroadways.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.rk.railroadways.entity.blockentity.custom.DynamicSignBE;
import net.rk.railroadways.menu.DynamicSignMenu;
import net.rk.railroadways.network.record.DynamicSignPayload;
import net.rk.railroadways.screen.widget.ActionCheckbox;
import net.rk.railroadways.screen.widget.DynamicEditBox;
import net.rk.thingamajigs.screen.widget.RevertedButton;
import net.rk.thingamajigs.xtras.TColors;

public class DynamicSignScreen
extends AbstractContainerScreen<DynamicSignMenu> {
    private static final HashMap<String, Object> guistate = DynamicSignMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private DynamicSignBE dsbe;
    private RevertedButton decreaseRotation;
    private RevertedButton increaseRotation;
    private RevertedButton decreaseType;
    private RevertedButton increaseType;
    private RevertedButton updateBlock;
    private EditBox customTextureEdit;
    private ActionCheckbox customTextureEnable;
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.parse((String)"thingamajigsrailroadways:textures/gui/rrc_component_setup_bg.png");

    public DynamicSignScreen(DynamicSignMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
        int widthx = (this.width - this.imageWidth) / 2;
        int heighty = (this.height - this.imageHeight) / 2;
        this.dsbe = (DynamicSignBE)this.world.getBlockEntity(new BlockPos(this.x, this.y, this.z));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, true);
        if (this.dsbe.customSign) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"container.thingamajigsrailroadways.dynamic_sign.custom_on"), this.titleLabelX + 9, this.titleLabelY + 79, TColors.getWhite(), true);
        } else {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"container.thingamajigsrailroadways.dynamic_sign.custom_off"), this.titleLabelX + 9, this.titleLabelY + 79, TColors.getWhite(), true);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"container.thingamajigsrailroadways.dynamic_sign.sign_type", (Object[])new Object[]{this.dsbe.signType}), this.titleLabelX + 9, this.titleLabelY + 98, TColors.getWhite(), true);
        String signtypename = switch (this.dsbe.signType) {
            case 0 -> "sign_type.aust_alt";
            case 1 -> "sign_type.aust";
            case 2 -> "sign_type.canadian";
            case 3 -> "sign_type.cateye";
            case 4 -> "sign_type.czech";
            case 5 -> "sign_type.finnish";
            case 6 -> "sign_type.german_horz";
            case 7 -> "sign_type.german_vert";
            case 8 -> "sign_type.inverted_cateye";
            case 9 -> "sign_type.japan";
            case 10 -> "sign_type.usa";
            case 11 -> "sign_type.rr_ahead";
            case 12 -> "sign_type.rr_ahead_old";
            case 13 -> "sign_type.stop_when_red_lights_show";
            case 14 -> "sign_type.inverted_usa";
            default -> "sign_type.unset";
        };
        if (this.dsbe.customSign) {
            signtypename = "sign_type.custom";
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)signtypename), this.titleLabelX + 9, this.titleLabelY + 115, TColors.getWhite(), true);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        guiGraphics.blit(RenderType.GUI_TEXTURED, BG_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public void containerTick() {
        super.containerTick();
    }

    public void onClose() {
        super.onClose();
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.customTextureEdit.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int key, int b, int c) {
        return this.customTextureEdit.keyPressed(key, b, c) || this.customTextureEdit.isFocused() && key != 256 || super.keyPressed(key, b, c);
    }

    protected void init() {
        super.init();
        this.setupWidgets();
        this.addRenderableWidget((GuiEventListener)this.decreaseRotation);
        this.addRenderableWidget((GuiEventListener)this.increaseRotation);
        this.addRenderableWidget((GuiEventListener)this.decreaseType);
        this.addRenderableWidget((GuiEventListener)this.increaseType);
        this.addRenderableWidget((GuiEventListener)this.updateBlock);
        this.addRenderableWidget((GuiEventListener)this.customTextureEdit);
        this.addRenderableWidget((GuiEventListener)this.customTextureEnable);
    }

    private void setupWidgets() {
        int spacingButtonWidth;
        int horzLeftButtonPos = this.leftPos + 25;
        int topRowButtonY = this.topPos + 25;
        int spacingButtonHeight = spacingButtonWidth = 2;
        float lowPitch = 0.95f;
        float normalPitch = 1.0f;
        this.customTextureEdit = new DynamicEditBox(this.font, this.leftPos + 12, this.topPos + 139, 154, 19, (Component)Component.literal((String)this.dsbe.customTextureLoc).withStyle(ChatFormatting.DARK_GRAY));
        this.customTextureEdit.setEditable(true);
        this.customTextureEdit.setValue(this.dsbe.customTextureLoc);
        this.customTextureEnable = new ActionCheckbox(this.leftPos + 89, this.topPos + 99, 76, (Component)Component.translatable((String)"checkbox.title.dynamic_sign_crossbuck").withStyle(ChatFormatting.YELLOW), this.font, this.dsbe.customSign);
        this.decreaseRotation = new RevertedButton(this, horzLeftButtonPos, topRowButtonY, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.dec_gate_rot"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(new BlockPos(this.x, this.y, this.z), this.dsbe.yAngle - 0.05f, this.dsbe.signType, false, this.dsbe.customSign, this.dsbe.customTextureLoc), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)lowPitch));
        }){};
        int horzRightButtonPos = this.decreaseRotation.getX() + this.decreaseRotation.getWidth() + spacingButtonWidth;
        this.increaseRotation = new RevertedButton(this, horzRightButtonPos, topRowButtonY, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.inc_gate_rot"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(new BlockPos(this.x, this.y, this.z), this.dsbe.yAngle + 0.05f, this.dsbe.signType, false, this.dsbe.customSign, this.dsbe.customTextureLoc), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)normalPitch));
        }){};
        int secondRowY = this.decreaseRotation.getY() + this.decreaseRotation.getHeight() + spacingButtonHeight;
        this.decreaseType = new RevertedButton(this, horzLeftButtonPos, secondRowY, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.dec_sign_type"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(new BlockPos(this.x, this.y, this.z), this.dsbe.yAngle, this.dsbe.signType - 1, false, this.dsbe.customSign, this.dsbe.customTextureLoc), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)lowPitch));
        }){};
        this.increaseType = new RevertedButton(this, horzRightButtonPos, secondRowY, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.inc_sign_type"), handler -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(new BlockPos(this.x, this.y, this.z), this.dsbe.yAngle, this.dsbe.signType + 1, false, this.dsbe.customSign, this.dsbe.customTextureLoc), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.ITEM_PICKUP, (float)normalPitch));
        }){};
        this.updateBlock = new RevertedButton(this, horzLeftButtonPos, secondRowY + this.decreaseType.getHeight() + spacingButtonHeight, 64, 16, (Component)Component.translatable((String)"button.thingamajigsrailroadways.update_block"), handler -> PacketDistributor.sendToServer((CustomPacketPayload)new DynamicSignPayload(new BlockPos(this.x, this.y, this.z), this.dsbe.yAngle, this.dsbe.signType, true, this.customTextureEnable.selected(), this.customTextureEdit.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0])){};
    }
}

