









var MAX_PLAYLISTS = 10; 
var SLOTS_PER_PLAYLIST = 10;
var OMNITRIX_PROPERTY_KEY = 'omnitrix_cycle';
var CURRENT_PLAYLIST_KEY = 'current_playlist';
var CURRENT_ALIEN_SLOT_KEY = 'current_alien_slot';


function toJsString(v) { if (v === null || v === undefined) return null; try { return String(v); } catch (e) { return null; } }
function normalizeHex6(s) {
  s = toJsString(s);
  if (!s) return null;
  s = s.trim();
  if (s.charAt(0) === '#') s = s.substring(1);
  return /^[0-9a-fA-F]{6}$/.test(s) ? s.toLowerCase() : null;
}
function normalizeRgbCsv(s) {
  s = toJsString(s);
  if (!s) return null;
  var m = s.trim().match(/^(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})$/);
  if (!m) return null;
  function clamp(n) { n = parseInt(n, 10); if (isNaN(n)) n = 0; return Math.max(0, Math.min(255, n)); }
  var r = clamp(m[1]), g = clamp(m[2]), b = clamp(m[3]);
  return r + ',' + g + ',' + b;
}





function inferWatchPrefixFromItemId(itemId) {
  try {
    var name = itemId.split(':')[1] || itemId;
    var base = name.split('_omnitrix')[0];
    var first = base.split('_')[0];
    first = first.toLowerCase().replace(/[^a-z0-9_]/g, '');
    return first || null;
  } catch (e) { return null; }
}


function getWatchPrefix(entity) {
  var raw = palladium.getProperty(entity, 'watch');
  var s = toJsString(raw);
  if (!s) return 'prototype';
  s = s.trim().toLowerCase().replace(/[^a-z0-9_]/g, '');
  return s || 'prototype';
}


function getWatchItemId(prefix, phase, stage) {
  if (phase === 1 && stage === 2) return 'alienevo:' + prefix + '_omnitrix_10k';
  return 'alienevo:' + prefix + '_omnitrix';
}


function getDecoupleSoundId(prefix) { return 'alienevo:' + prefix + '_decouple'; }


function getWatchSuperpowerId(prefix) { return new ResourceLocation('aeo:' + prefix + '_omnitrix'); }


function updateAllSlotProperties(entity, playlist) {
  try {
    for (var slot = 1; slot <= SLOTS_PER_PLAYLIST; slot++) {
      var alienKey = 'alienevo.alien_' + playlist + '_' + slot;
      var storedAlienId = entity.persistentData.getInt(alienKey);
      palladium.setProperty(entity, 'alien_evo_slot_' + slot, storedAlienId || 0);
    }
    console.log('Successfully updated slot properties for playlist ' + playlist);
  } catch (error) {
    console.log('Error in updateAllSlotProperties: ' + error);
  }
}


function getAlienName(alienId, entity) {
  var alienInfo = global['alienevo_alien_' + alienId];
  if (alienInfo) {
    var fullName = alienInfo[0];
    return (fullName.indexOf(':') !== -1) ? fullName.split(':')[1] : fullName;
  }
  if (entity) {
    var storedName = entity.persistentData.getString('alienevo.alien_name_' + alienId);
    if (storedName) return storedName;
  }
  return 'alien_' + alienId;
}


function readGlowHex(entity, idx, keyPrefix) {
  var raw = palladium.getProperty(entity, keyPrefix + idx);
  return normalizeHex6(raw);
}
function writeGlowHex(entity, idx, hex, keyPrefix) {
  var v = normalizeHex6(hex);
  if (v) palladium.setProperty(entity, keyPrefix + idx, v);
}
function readGlowBase(entity, key) { return normalizeRgbCsv(palladium.getProperty(entity, key)); }
function writeGlowBase(entity, key, csv) {
  var v = normalizeRgbCsv(csv);
  if (v) palladium.setProperty(entity, key, v);
}


function resetWatchGlowDefaults(entity, prefix) {
  palladium.setProperty(entity, prefix + '_glow_color_base', '0,0,0');
  palladium.setProperty(entity, prefix + '_glow_color_1', 'dbffae');
  palladium.setProperty(entity, prefix + '_glow_color_2', 'b3ff40');
  palladium.setProperty(entity, prefix + '_glow_color_3', 'a7f72e');
  palladium.setProperty(entity, prefix + '_glow_color_4', '8ed721');
  palladium.setProperty(entity, prefix + '_glow_color_5', '6ca018');
}


function shouldUseUniformProperties(watchPrefix) {
  return watchPrefix === 'prototype' || watchPrefix === '10k';
}


function getUniformColorPrefix(watchPrefix, colorType) {
  if (shouldUseUniformProperties(watchPrefix)) {
    return 'uniform_' + colorType + '_color_';
  } else {
    return watchPrefix + '_' + colorType + '_color_';
  }
}


function getUniformColorBaseName(watchPrefix, colorType) {
  if (shouldUseUniformProperties(watchPrefix)) {
    return 'uniform_' + colorType + '_color_base';
  } else {
    return watchPrefix + '_' + colorType + '_color_base';
  }
}


function resetUniformGlowDefaults(entity) {
  palladium.setProperty(entity, 'uniform_glow_color_base', '0,0,0');
  palladium.setProperty(entity, 'uniform_glow_color_1', 'dbffae');
  palladium.setProperty(entity, 'uniform_glow_color_2', 'b3ff40');
  palladium.setProperty(entity, 'uniform_glow_color_3', 'a7f72e');
  palladium.setProperty(entity, 'uniform_glow_color_4', '8ed721');
  palladium.setProperty(entity, 'uniform_glow_color_5', '6ca018');
}

function resetUniformTertDefaults(entity, watchPrefix) {
  var prefix = getUniformColorPrefix(watchPrefix, 'tertiary');
  var baseName = getUniformColorBaseName(watchPrefix, 'tertiary');
  palladium.setProperty(entity, baseName, '0,0,0');

  if (shouldUseUniformProperties(watchPrefix)) {
    
    palladium.setProperty(entity, prefix + '1', 'ace53b');
    palladium.setProperty(entity, prefix + '2', '83d41c');
    palladium.setProperty(entity, prefix + '3', '6bbf17');
    palladium.setProperty(entity, prefix + '4', '4ca80f');
    palladium.setProperty(entity, prefix + '5', '35900b');
  } else {
    
    palladium.setProperty(entity, prefix + '1', 'ace53b');
    palladium.setProperty(entity, prefix + '2', '83d41c');
    palladium.setProperty(entity, prefix + '3', '6bbf17');
    palladium.setProperty(entity, prefix + '4', '4ca80f');
    palladium.setProperty(entity, prefix + '5', '35900b');
  }
}

function resetUniformPrimDefaults(entity, watchPrefix) {
  var prefix = getUniformColorPrefix(watchPrefix, 'primary');
  var baseName = getUniformColorBaseName(watchPrefix, 'primary');
  palladium.setProperty(entity, baseName, '0,0,0');

  if (shouldUseUniformProperties(watchPrefix)) {
    
    palladium.setProperty(entity, prefix + '1', '3a3333');
    palladium.setProperty(entity, prefix + '2', '2c2828');
    palladium.setProperty(entity, prefix + '3', '232020');
    palladium.setProperty(entity, prefix + '4', '171515');
    palladium.setProperty(entity, prefix + '5', '000000');
  } else {
    
    palladium.setProperty(entity, prefix + '1', '3a3333');
    palladium.setProperty(entity, prefix + '2', '2c2828');
    palladium.setProperty(entity, prefix + '3', '232020');
    palladium.setProperty(entity, prefix + '4', '171515');
    palladium.setProperty(entity, prefix + '5', '000000');
  }
}

function resetUniformSecDefaults(entity, watchPrefix) {
  var prefix = getUniformColorPrefix(watchPrefix, 'secondary');
  var baseName = getUniformColorBaseName(watchPrefix, 'secondary');
  palladium.setProperty(entity, baseName, '0,0,0');

  if (shouldUseUniformProperties(watchPrefix)) {
    
    palladium.setProperty(entity, prefix + '1', 'ffffff');
    palladium.setProperty(entity, prefix + '2', 'edf4f4');
    palladium.setProperty(entity, prefix + '3', 'd6dfe1');
    palladium.setProperty(entity, prefix + '4', 'bdc7cf');
    palladium.setProperty(entity, prefix + '5', '97a2b0');
  } else {
    
    palladium.setProperty(entity, prefix + '1', 'ffffff');
    palladium.setProperty(entity, prefix + '2', 'edf4f4');
    palladium.setProperty(entity, prefix + '3', 'd6dfe1');
    palladium.setProperty(entity, prefix + '4', 'bdc7cf');
    palladium.setProperty(entity, prefix + '5', '97a2b0');
  }
}






function collectAndResetGeneratedAlienGlowProps(entity) {
  var result = {};
  var GLOW_DEF_RE = /^alienevo_(\d+)_([^]+?)_glowcolor_(\d+)(.*)$/;

  Object.keys(global).forEach(function (key) {
    var m = key.match(GLOW_DEF_RE);
    if (!m) return;

    var alienId = m[1];
    var variationName = m[2];
    var glowId = m[3];
    var suffix = m[4] || '';
    var defArray = global[key];
    if (!Array.isArray(defArray)) return;

    var alienInfo = global['alienevo_alien_' + alienId];
    if (!alienInfo || !alienInfo[0]) return;
    var alienFullName = String(alienInfo[0]);
    var alienName = alienFullName.indexOf(':') !== -1 ? alienFullName.split(':')[1] : alienFullName;

    var prefix = alienName + '_' + variationName + '_glowcolor_' + glowId + (suffix || '');

    
    var baseKey = prefix + '_base';
    var baseVal = readGlowBase(entity, baseKey);

    var storedColors = [];
    for (var i = 0; i < defArray.length; i++) {
      var colorKey = prefix + '_color_' + (i + 1);
      var val = normalizeHex6(palladium.getProperty(entity, colorKey));
      storedColors.push(val);
    }

    var hasSomething = !!baseVal || storedColors.some(function (c) { return !!c; });
    if (hasSomething) {
      result[prefix] = { base: baseVal, colors: storedColors };
    }

    
    var explicitDefaultKey = 'alienevo_' + alienId + '_default_glowcolor_' + glowId;
    var defaultArr = Array.isArray(global[explicitDefaultKey]) ? global[explicitDefaultKey] : defArray;

    for (var j = 0; j < defaultArr.length; j++) {
      var defColor = normalizeHex6(defaultArr[j]);
      if (defColor) palladium.setProperty(entity, prefix + '_color_' + (j + 1), defColor);
    }
    palladium.setProperty(entity, baseKey, '0,0,0');
  });

  return result;
}

function restoreGeneratedAlienGlowProps(entity, stored) {
  if (!stored || typeof stored !== 'object') return;
  Object.keys(stored).forEach(function (prefix) {
    var bundle = stored[prefix];
    if (!bundle) return;
    if (typeof bundle.base === 'string') {
      var baseVal = normalizeRgbCsv(bundle.base);
      if (baseVal) palladium.setProperty(entity, prefix + '_base', baseVal);
    }
    if (Array.isArray(bundle.colors)) {
      for (var i = 0; i < bundle.colors.length; i++) {
        var hex = normalizeHex6(bundle.colors[i]);
        if (hex) palladium.setProperty(entity, prefix + '_color_' + (i + 1), hex);
      }
    }
  });
}




function applyCodexGlowDefaultsForWatch(entity, watchPrefix) {
  var DEF_RE = /^alienevo_(\d+)_([^]+?)_glowcolor_(\d+)(.*)$/;

  
  var hasExplicit = {};
  Object.keys(global).forEach(function (key) {
    var m = key.match(DEF_RE);
    if (!m) return;
    var alienId = m[1], variation = m[2], glowId = m[3], suffix = m[4] || '';
    if (variation === watchPrefix) {
      hasExplicit[alienId + '|' + glowId + '|' + suffix] = true;
    }
  });

  
  Object.keys(global).forEach(function (key) {
    var m = key.match(DEF_RE);
    if (!m) return;

    var alienId = m[1];
    var variation = m[2];
    var glowId = m[3];
    var suffix = m[4] || '';
    var arr = global[key];
    if (!Array.isArray(arr)) return;

    var combo = alienId + '|' + glowId + '|' + suffix;
    var useThis = (variation === watchPrefix) || (variation === 'default' && !hasExplicit[combo]);
    if (!useThis) return;

    var info = global['alienevo_alien_' + alienId];
    if (!info || !info[0]) return;
    var full = String(info[0]);
    var alienName = full.indexOf(':') !== -1 ? full.split(':')[1] : full;

    
    var resolvedVariation = (variation === 'default' && hasExplicit[combo]) ? watchPrefix : variation;
    var prefix = alienName + '_' + resolvedVariation + '_glowcolor_' + glowId + suffix;

    for (var i = 0; i < arr.length; i++) {
      var hex = normalizeHex6(arr[i]);
      if (hex) palladium.setProperty(entity, prefix + '_color_' + (i + 1), hex);
    }
    palladium.setProperty(entity, prefix + '_base', '0,0,0');
  });
}




function applyWatchGlobalPalette(entity, watchPrefix) {
  
  var mainPalette = global['watch_palette_' + watchPrefix];
  if (Array.isArray(mainPalette) && mainPalette.length === 5) {
    var wgPrefix = watchPrefix + '_glow_color_';
    for (var i = 0; i < 5; i++) {
      var hex = normalizeHex6(mainPalette[i]);
      if (hex) palladium.setProperty(entity, wgPrefix + (i + 1), hex);
    }
    palladium.setProperty(entity, watchPrefix + '_glow_color_base', '0,0,0');
    console.log('Applied watch glow palette for ' + watchPrefix + ':', mainPalette);
    
    
    var ugPrefix = 'uniform_glow_color_';
    for (var i = 1; i <= 3; i++) {
      var hex = normalizeHex6(mainPalette[i]); 
      if (hex) palladium.setProperty(entity, ugPrefix + i, hex);
    }
    palladium.setProperty(entity, 'uniform_glow_color_base', '0,0,0');
    console.log('Applied uniform glow palette (aliens/badge) for ' + watchPrefix + ' using colors 2-4:', [mainPalette[1], mainPalette[2], mainPalette[3]]);
  }

  
  var tertiaryPalette = global['watch_palette_' + watchPrefix + '_uniform_tertiary'];
  if (Array.isArray(tertiaryPalette) && tertiaryPalette.length === 5) {
    var utPrefix = getUniformColorPrefix(watchPrefix, 'tertiary');
    for (var i = 0; i < 5; i++) {
      var hex = normalizeHex6(tertiaryPalette[i]);
      if (hex) palladium.setProperty(entity, utPrefix + (i + 1), hex);
    }
    palladium.setProperty(entity, getUniformColorBaseName(watchPrefix, 'tertiary'), '0,0,0');
    console.log('Applied uniform tertiary palette for ' + watchPrefix + ':', tertiaryPalette);
  }

  
  var primaryPalette = global['watch_palette_' + watchPrefix + '_uniform_primary'];
  if (Array.isArray(primaryPalette) && primaryPalette.length === 5) {
    var upPrefix = getUniformColorPrefix(watchPrefix, 'primary');
    for (var i = 0; i < 5; i++) {
      var hex = normalizeHex6(primaryPalette[i]);
      if (hex) palladium.setProperty(entity, upPrefix + (i + 1), hex);
    }
    palladium.setProperty(entity, getUniformColorBaseName(watchPrefix, 'primary'), '0,0,0');
    console.log('Applied uniform primary palette for ' + watchPrefix + ':', primaryPalette);
  }

  
  var secondaryPalette = global['watch_palette_' + watchPrefix + '_uniform_secondary'];
  if (Array.isArray(secondaryPalette) && secondaryPalette.length === 5) {
    var usPrefix = getUniformColorPrefix(watchPrefix, 'secondary');
    for (var i = 0; i < 5; i++) {
      var hex = normalizeHex6(secondaryPalette[i]);
      if (hex) palladium.setProperty(entity, usPrefix + (i + 1), hex);
    }
    palladium.setProperty(entity, getUniformColorBaseName(watchPrefix, 'secondary'), '0,0,0');
    console.log('Applied uniform secondary palette for ' + watchPrefix + ':', secondaryPalette);
  }
}




function createAndGiveOmnitrix(entity) {
  var watchPrefix = getWatchPrefix(entity);

  var allDNA = {};
  var storedAlienCount = 0;

  var storedItemName = entity.persistentData.getString('storedItemName') || '';
  var alienNamespaceData = {};

  
  var currentPlaylist = entity.persistentData.getInt(CURRENT_PLAYLIST_KEY) || 1;
  var currentAlienSlot = entity.persistentData.getInt(CURRENT_ALIEN_SLOT_KEY) || 1;

  
  for (var playlist = 1; playlist <= MAX_PLAYLISTS; playlist++) {
    allDNA[playlist] = {};
    for (var slot = 1; slot <= SLOTS_PER_PLAYLIST; slot++) {
      var alienKey = 'alienevo.alien_' + playlist + '_' + slot;
      var alienId = entity.persistentData.getInt(alienKey);
      if (alienId && alienId !== 0) {
        var info = global['alienevo_alien_' + alienId];
        var alienName = 'Unknown';
        var alienNamespace = 'alienevo_aliens';

        if (info) {
          var alienFullName = info[0];
          if (alienFullName.indexOf(':') !== -1) {
            var parts = alienFullName.split(':');
            alienNamespace = parts[0];
            alienName = parts[1];
          } else {
            alienName = alienFullName;
          }
          alienNamespaceData[alienId] = { namespace: alienNamespace, name: alienName };
        } else {
          alienName = getAlienName(alienId, entity);
        }

        allDNA[playlist][slot] = { alienId: alienId, alienName: alienName };
        storedAlienCount++;
        entity.persistentData.putInt(alienKey, 0); 
      }
    }
  }

  var username = entity.getGameProfile().getName();

  
  function getScore(scoreName) {
    var scoreResult = entity.server.runCommandSilent('scoreboard players get ' + username + ' ' + scoreName);
    return isNaN(scoreResult) ? 0 : parseInt(scoreResult);
  }
  var basePrimaryScore = getScore('AlienEvo.BasePrimary');
  var baseSecondaryScore = getScore('AlienEvo.BaseSecondary');
  var baseTertiaryScore = getScore('AlienEvo.BaseTertiary');
  var buttonsScore = getScore('AlienEvo.Buttons');
  var coreSideScore = getScore('AlienEvo.CoreSide');
  var coreTopScore = getScore('AlienEvo.CoreTop');
  var dialInnerScore = getScore('AlienEvo.DialInner');
  var dialOuterScore = getScore('AlienEvo.DialOuter');
  var tubesScore = getScore('AlienEvo.Tubes');
  var phase10kScore = getScore('AlienEvo.10kPhase');
  var stage10kScore = getScore('AlienEvo.10kStage');
  var spikesScore = getScore('AEO.Spikes');
  var faceplateScore = getScore('AEO.Faceplate');
  var airBreatherScore = getScore('AEO.AirBreather');
  var suitScore = getScore('AEO.Suit');
  var batteryScore = getScore('AEO.Battery');

  
  var currentCode = entity.persistentData.getString('code') || '000000';
  var currentPosition = entity.persistentData.getString('position') || '0';
  var masterTargetCode = entity.persistentData.getString('masterTargetCode') || '';
  var randomizerTargetCode = entity.persistentData.getString('randomizerTargetCode') || '';

  
  var wgPrefix = watchPrefix + '_glow_color_';
  var glow1 = readGlowHex(entity, 1, wgPrefix);
  var glow2 = readGlowHex(entity, 2, wgPrefix);
  var glow3 = readGlowHex(entity, 3, wgPrefix);
  var glow4 = readGlowHex(entity, 4, wgPrefix);
  var glow5 = readGlowHex(entity, 5, wgPrefix);
  var watchBase = readGlowBase(entity, watchPrefix + '_glow_color_base');

  
  var ugPrefix = 'uniform_glow_color_';
  var uGlow1 = readGlowHex(entity, 1, ugPrefix);
  var uGlow2 = readGlowHex(entity, 2, ugPrefix);
  var uGlow3 = readGlowHex(entity, 3, ugPrefix);
  var uGlow4 = readGlowHex(entity, 4, ugPrefix);
  var uGlow5 = readGlowHex(entity, 5, ugPrefix);
  var uniformBase = readGlowBase(entity, 'uniform_glow_color_base');

  var utPrefix = getUniformColorPrefix(watchPrefix, 'tertiary');
  var uT1 = readGlowHex(entity, 1, utPrefix);
  var uT2 = readGlowHex(entity, 2, utPrefix);
  var uT3 = readGlowHex(entity, 3, utPrefix);
  var uT4 = readGlowHex(entity, 4, utPrefix);
  var uT5 = readGlowHex(entity, 5, utPrefix);
  var uniformTBase = readGlowBase(entity, getUniformColorBaseName(watchPrefix, 'tertiary'));

  var usPrefix = getUniformColorPrefix(watchPrefix, 'secondary');
  var uS1 = readGlowHex(entity, 1, usPrefix);
  var uS2 = readGlowHex(entity, 2, usPrefix);
  var uS3 = readGlowHex(entity, 3, usPrefix);
  var uS4 = readGlowHex(entity, 4, usPrefix);
  var uS5 = readGlowHex(entity, 5, usPrefix);
  var uniformSBase = readGlowBase(entity, getUniformColorBaseName(watchPrefix, 'secondary'));

  var upPrefix = getUniformColorPrefix(watchPrefix, 'primary');
  var uP1 = readGlowHex(entity, 1, upPrefix);
  var uP2 = readGlowHex(entity, 2, upPrefix);
  var uP3 = readGlowHex(entity, 3, upPrefix);
  var uP4 = readGlowHex(entity, 4, upPrefix);
  var uP5 = readGlowHex(entity, 5, upPrefix);
  var uniformPBase = readGlowBase(entity, getUniformColorBaseName(watchPrefix, 'primary'));

  
  
  var genUpPrefix = 'uniform_primary_color_';
  var genUP1 = readGlowHex(entity, 1, genUpPrefix);
  var genUP2 = readGlowHex(entity, 2, genUpPrefix);
  var genUP3 = readGlowHex(entity, 3, genUpPrefix);
  var genUP4 = readGlowHex(entity, 4, genUpPrefix);
  var genUP5 = readGlowHex(entity, 5, genUpPrefix);
  var genUniformPBase = readGlowBase(entity, 'uniform_primary_color_base');

  var hasMastercontrol = entity.tags.contains('AlienEvo.MasterControl');

  
  var nbtData = {
    storedAllDNA: JSON.stringify(allDNA),
    storedAlienCount: storedAlienCount,
    storedAlienNamespaces: JSON.stringify(alienNamespaceData),
    storedCurrentPlaylist: currentPlaylist,
    storedCurrentAlienSlot: currentAlienSlot,
    storedOmnitrixCycle: currentAlienSlot,
    storedBasePrimaryScore: basePrimaryScore,
    storedBaseSecondaryScore: baseSecondaryScore,
    storedBaseTertiaryScore: baseTertiaryScore,
    storedButtonsScore: buttonsScore,
    storedCoreSideScore: coreSideScore,
    storedCoreTopScore: coreTopScore,
    storedDialInnerScore: dialInnerScore,
    storedDialOuterScore: dialOuterScore,
    storedTubesScore: tubesScore,
    stored10kPhaseScore: phase10kScore,
    stored10kStageScore: stage10kScore,
    storedSpikesScore: spikesScore,
    storedFaceplateScore: faceplateScore,
  storedAeoAirBreatherPersistent: !!entity.persistentData.getBoolean('AEO_AirBreather'),
  storedAeoAirBreatherScore: airBreatherScore,
  storedAeoBatteryPersistent: !!entity.persistentData.getBoolean('AEO_Battery'),
  storedAeoBatteryScore: (typeof batteryScore !== 'undefined') ? batteryScore : 0,
  storedAeoSuitPersistent: !!entity.persistentData.getBoolean('AEO_Suit'),
  storedAeoSuitScore: suitScore,
    storedCode: currentCode,
    storedPosition: currentPosition,
    storedMasterTargetCode: masterTargetCode,
    storedRandomizerTargetCode: randomizerTargetCode,
    storedMastercontrol: hasMastercontrol,
    storedRandomizerUnlocked: !!entity.tags.contains('AEO.RandomizerUnlocked'),
    storedWatch: watchPrefix
  };
  if (storedItemName && storedItemName !== '') {
    nbtData.display = { Name: storedItemName };
    entity.persistentData.remove('storedItemName');
  }

  
  if (glow1) nbtData.storedGlowColor1 = glow1;
  if (glow2) nbtData.storedGlowColor2 = glow2;
  if (glow3) nbtData.storedGlowColor3 = glow3;
  if (glow4) nbtData.storedGlowColor4 = glow4;
  if (glow5) nbtData.storedGlowColor5 = glow5;
  if (watchBase) nbtData.storedGlowColorBase = watchBase;

  
  if (uGlow1) nbtData.storedUniformGlowColor1 = uGlow1;
  if (uGlow2) nbtData.storedUniformGlowColor2 = uGlow2;
  if (uGlow3) nbtData.storedUniformGlowColor3 = uGlow3;
  if (uGlow4) nbtData.storedUniformGlowColor4 = uGlow4;
  if (uGlow5) nbtData.storedUniformGlowColor5 = uGlow5;
  if (uniformBase) nbtData.storedUniformGlowColorBase = uniformBase;

  if (uT1) nbtData.storedUniformTertiaryColor1 = uT1;
  if (uT2) nbtData.storedUniformTertiaryColor2 = uT2;
  if (uT3) nbtData.storedUniformTertiaryColor3 = uT3;
  if (uT4) nbtData.storedUniformTertiaryColor4 = uT4;
  if (uT5) nbtData.storedUniformTertiaryColor5 = uT5;
  if (uniformTBase) nbtData.storedUniformTertiaryColorBase = uniformTBase;

  if (uP1) nbtData.storedUniformPrimaryColor1 = uP1;
  if (uP2) nbtData.storedUniformPrimaryColor2 = uP2;
  if (uP3) nbtData.storedUniformPrimaryColor3 = uP3;
  if (uP4) nbtData.storedUniformPrimaryColor4 = uP4;
  if (uP5) nbtData.storedUniformPrimaryColor5 = uP5;
  if (uniformPBase) nbtData.storedUniformPrimaryColorBase = uniformPBase;

  
  if (genUP1) nbtData.storedGenericUniformPrimaryColor1 = genUP1;
  if (genUP2) nbtData.storedGenericUniformPrimaryColor2 = genUP2;
  if (genUP3) nbtData.storedGenericUniformPrimaryColor3 = genUP3;
  if (genUP4) nbtData.storedGenericUniformPrimaryColor4 = genUP4;
  if (genUP5) nbtData.storedGenericUniformPrimaryColor5 = genUP5;
  if (genUniformPBase) nbtData.storedGenericUniformPrimaryColorBase = genUniformPBase;

  if (uS1) nbtData.storedUniformSecondaryColor1 = uS1;
  if (uS2) nbtData.storedUniformSecondaryColor2 = uS2;
  if (uS3) nbtData.storedUniformSecondaryColor3 = uS3;
  if (uS4) nbtData.storedUniformSecondaryColor4 = uS4;
  if (uS5) nbtData.storedUniformSecondaryColor5 = uS5;
  if (uniformSBase) nbtData.storedUniformSecondaryColorBase = uniformSBase;

  
  var genUsPrefix = 'uniform_secondary_color_';
  var genUS1 = readGlowHex(entity, 1, genUsPrefix);
  var genUS2 = readGlowHex(entity, 2, genUsPrefix);
  var genUS3 = readGlowHex(entity, 3, genUsPrefix);
  var genUS4 = readGlowHex(entity, 4, genUsPrefix);
  var genUS5 = readGlowHex(entity, 5, genUsPrefix);
  var genUniformSBase = readGlowBase(entity, 'uniform_secondary_color_base');

  if (genUS1) nbtData.storedGenericUniformSecondaryColor1 = genUS1;
  if (genUS2) nbtData.storedGenericUniformSecondaryColor2 = genUS2;
  if (genUS3) nbtData.storedGenericUniformSecondaryColor3 = genUS3;
  if (genUS4) nbtData.storedGenericUniformSecondaryColor4 = genUS4;
  if (genUS5) nbtData.storedGenericUniformSecondaryColor5 = genUS5;
  if (genUniformSBase) nbtData.storedGenericUniformSecondaryColorBase = genUniformSBase;

  
  var generatedAlienGlowProps = collectAndResetGeneratedAlienGlowProps(entity);
  if (generatedAlienGlowProps && Object.keys(generatedAlienGlowProps).length) {
    nbtData.storedAlienGlowProps = JSON.stringify(generatedAlienGlowProps);
  }


  
  
  
  
  var customModelData = 0;
  try {
    
    var hex = null;
    if (uT1) hex = uT1; 

    
    if (!hex) {
      try {
        var watchPrefix = watchPrefix || getWatchPrefix(entity);
      } catch (e) { watchPrefix = getWatchPrefix(entity); }
      try {
        var watchT1 = normalizeHex6(palladium.getProperty(entity, watchPrefix + '_tertiary_color_1'));
        if (watchT1) hex = watchT1;
      } catch (e) {}
    }

    
    if (!hex) {
      if (glow1) hex = glow1;
    }

    
    if (!hex && uP1) hex = uP1;
    if (!hex) hex = null;

    if (hex) {
      
      var numeric = parseInt(hex, 16);
      if (!isNaN(numeric)) {
        
        
        customModelData = numeric & 0xFFFFFFFF;
      }
    } else {
      
      try {
        var prop = palladium.getProperty(entity, 'watch_color');
        if (typeof prop === 'number') customModelData = prop;
        else if (typeof prop === 'string' && prop.length > 0) customModelData = parseInt(prop) || 0;
      } catch (e) { customModelData = customModelData || 0; }
    }
  } catch (e) {
    customModelData = customModelData || 0;
  }

  
  nbtData.CustomModelData = customModelData;

  
  var itemId = getWatchItemId(watchPrefix, phase10kScore, stage10kScore);
  var watchItem = Item.of(itemId, 1, nbtData);

  console.log('Giving ' + itemId + ' with glow NBT:', {
    watch: watchPrefix,
    base: nbtData.storedGlowColorBase,
    c1: nbtData.storedGlowColor1, c2: nbtData.storedGlowColor2, c3: nbtData.storedGlowColor3,
    c4: nbtData.storedGlowColor4, c5: nbtData.storedGlowColor5,
    ubase: nbtData.storedUniformGlowColorBase,
    u1: nbtData.storedUniformGlowColor1, u2: nbtData.storedUniformGlowColor2, u3: nbtData.storedUniformGlowColor3,
    u4: nbtData.storedUniformGlowColor4, u5: nbtData.storedUniformGlowColor5,
    t1: nbtData.storedUniformTertiaryColor1, t2: nbtData.storedUniformTertiaryColor2,
    p1: nbtData.storedUniformPrimaryColor1, p2: nbtData.storedUniformPrimaryColor2,
    s1: nbtData.storedUniformSecondaryColor1, s2: nbtData.storedUniformSecondaryColor2,
    alienGlowPrefixes: Object.keys(generatedAlienGlowProps || {}),
    customModelData: customModelData
  });

  
  updateAllSlotProperties(entity, currentPlaylist);
  entity.give(watchItem);

  
  try {
    var held = entity.getMainHandItem();
    console.log('Player now holds:', held.id, 'NBT:', held.nbt);
  } catch (e) {
    console.log('Post-give inspect failed:', e);
  }

  
  entity.level.playSound(null, entity.x, entity.y, entity.z,
    getDecoupleSoundId(watchPrefix), entity.getSoundSource(), 1.0, 1.0);

  
  resetWatchGlowDefaults(entity, watchPrefix);
  resetUniformGlowDefaults(entity);
  resetUniformTertDefaults(entity, watchPrefix);
  resetUniformPrimDefaults(entity, watchPrefix);
  resetUniformSecDefaults(entity, watchPrefix);

  
  
  resetUniformPrimDefaults(entity, 'prototype');
  resetUniformSecDefaults(entity, 'prototype');

  
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.10kPhase 0');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.10kStage 0');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.BasePrimary -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.BaseSecondary -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.BaseTertiary -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.Buttons -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.CoreSide -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.CoreTop -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.DialInner -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.DialOuter -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AlienEvo.Tubes -1');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Spikes 0');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Faceplate 0');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.AirBreather 0');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Suit 0');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' AEO.Battery 0');

  entity.persistentData.remove('code');
  entity.persistentData.remove('position');
  entity.persistentData.remove('masterTargetCode');
  entity.persistentData.remove('randomizerTargetCode');
  entity.persistentData.remove('AEO_AirBreather');
  entity.persistentData.remove('AEO_Suit');
  entity.persistentData.remove('AEO_Battery');
  entity.server.runCommandSilent('scoreboard players set ' + username + ' code_position 0');
  palladium.setProperty(entity, 'code', '000000');

  
  entity.persistentData.remove(CURRENT_PLAYLIST_KEY);
  entity.persistentData.remove(CURRENT_ALIEN_SLOT_KEY);

  
  entity.tags.remove('AlienEvo.MasterControl');
  entity.tags.remove('AEO.AbilityUnlockRandomizer');
  entity.tags.remove('AlienEvo.BaseForm');
  entity.tags.remove('AlienEvo.Unworthy');
  entity.tags.remove('AEO.Battery');
  entity.tags.remove('AEO.Suited');
  superpowerUtil.removeSuperpower(entity, new ResourceLocation('alienevo:quick_change'));
  superpowerUtil.removeSuperpower(entity, new ResourceLocation('aeo:battery'));
  superpowerUtil.removeSuperpower(entity, getWatchSuperpowerId(watchPrefix));
}




function applyAllDNAFromOmnitrix(entity) {
  var mainHandItem = entity.getMainHandItem();
  if (mainHandItem.id.indexOf('alienevo:') !== 0 || mainHandItem.id.indexOf('_omnitrix') === -1) return;

  var itemId = mainHandItem.id;

  
  var inferred = inferWatchPrefixFromItemId(itemId) || 'prototype';
  palladium.setProperty(entity, 'watch', inferred);

  
  var watchPrefix = getWatchPrefix(entity);

  if (itemId.indexOf('_omnitrix_10k') !== -1) {
    var username10k = entity.getGameProfile().getName();
    entity.server.runCommandSilent('scoreboard players set ' + username10k + ' AlienEvo.10kPhase 1');
    entity.server.runCommandSilent('scoreboard players set ' + username10k + ' AlienEvo.10kStage 2');
  }

  var nbt = mainHandItem.nbt;

  
  if (!nbt) {
    var inferredNoNbt = inferWatchPrefixFromItemId(mainHandItem.id) || 'prototype';
    palladium.setProperty(entity, 'watch', inferredNoNbt);
    var watchPrefixNoNbt = getWatchPrefix(entity);

    
    applyCodexGlowDefaultsForWatch(entity, watchPrefixNoNbt);

    
    applyWatchGlobalPalette(entity, watchPrefixNoNbt);

    
    giveFirstTwentySplit(entity);

    entity.setMainHandItem(Item.of('minecraft:air'));
    return;
  }

  
  
  applyCodexGlowDefaultsForWatch(entity, watchPrefix);
  applyWatchGlobalPalette(entity, watchPrefix);

  var storedAllDNAString = nbt.storedAllDNA || '';
  if (!storedAllDNAString) {
    
    giveFirstTwentySplit(entity);
    entity.setMainHandItem(Item.of('minecraft:air'));
    return;
  }

  
  var displayNbt = nbt.display;
  var itemName = '';
  if (displayNbt && displayNbt.Name) {
    itemName = displayNbt.Name;
    entity.persistentData.putString('storedItemName', itemName);
  }

  
  var storedAllDNA;
  try { storedAllDNA = JSON.parse(storedAllDNAString); }
  catch (e) {
    giveFirstTwentySplit(entity);
    entity.setMainHandItem(Item.of('minecraft:air'));
    return;
  }

  
  var alienNamespaceData = {};
  try {
    if (nbt.storedAlienNamespaces) alienNamespaceData = JSON.parse(nbt.storedAlienNamespaces);
  } catch (e2) { alienNamespaceData = {}; }

  for (var p in storedAllDNA) {
    for (var s in storedAllDNA[p]) {
      var key = 'alienevo.alien_' + p + '_' + s;
      var alienData = storedAllDNA[p][s];

      if (alienData && alienData.alienId) {
        var alienId2 = alienData.alienId;
        entity.persistentData.putInt(key, alienId2);

        if (alienData.alienName) {
          entity.persistentData.putString('alienevo.alien_name_' + alienId2, alienData.alienName);
        }

        if (alienNamespaceData && alienNamespaceData[alienId2]) {
          var namespace = alienNamespaceData[alienId2].namespace || 'alienevo_aliens';
          var name = alienNamespaceData[alienId2].name || alienData.alienName || ('alien_' + alienId2);
          var alienInfo = [namespace + ':' + name];
          global['alienevo_alien_' + alienId2] = alienInfo;
        }
      }
    }
  }

  var username = entity.getGameProfile().getName();

  var storedOmnitrixCycle = nbt.storedOmnitrixCycle || 1;
  palladium.setProperty(entity, OMNITRIX_PROPERTY_KEY, storedOmnitrixCycle);

  var storedCode = nbt.storedCode || '000000';
  var storedPosition = nbt.storedPosition || '0';
  var storedMasterTargetCode = nbt.storedMasterTargetCode || '';
  var storedRandomizerTargetCode = nbt.storedRandomizerTargetCode || '';
  var storedAeoAirBreatherPersistent = (typeof nbt.storedAeoAirBreatherPersistent !== 'undefined') ? !!nbt.storedAeoAirBreatherPersistent : 0;
  var storedAeoAirBreatherScore = (typeof nbt.storedAeoAirBreatherScore !== 'undefined') ? nbt.storedAeoAirBreatherScore : 0;
  var storedAeoSuitPersistent = (typeof nbt.storedAeoSuitPersistent !== 'undefined') ? !!nbt.storedAeoSuitPersistent : 0;
  var storedAeoSuitScore = (typeof nbt.storedAeoSuitScore !== 'undefined') ? nbt.storedAeoSuitScore : 0;
  var storedAeoBatteryPersistent = (typeof nbt.storedAeoBatteryPersistent !== 'undefined') ? !!nbt.storedAeoBatteryPersistent : 0;
  var storedAeoBatteryScore = (typeof nbt.storedAeoBatteryScore !== 'undefined') ? nbt.storedAeoBatteryScore : 0;

  entity.persistentData.putString('code', storedCode);
  entity.persistentData.putString('position', storedPosition);
  entity.persistentData.putString('masterTargetCode', storedMasterTargetCode);
  entity.persistentData.putString('randomizerTargetCode', storedRandomizerTargetCode);

  try {
    if (typeof storedAeoAirBreatherPersistent !== 'undefined') {
      if (storedAeoAirBreatherPersistent) entity.persistentData.putBoolean('AEO_AirBreather', true);
      else entity.persistentData.putBoolean('AEO_AirBreather', false);
    }
  } catch (e) { }

  try {
    if (typeof storedAeoSuitPersistent !== 'undefined') {
      if (storedAeoSuitPersistent) entity.persistentData.putBoolean('AEO_Suit', true);
      else entity.persistentData.putBoolean('AEO_Suit', false);
    }
  } catch (e) { }
  try {
    if (typeof storedAeoBatteryPersistent !== 'undefined') {
      if (storedAeoBatteryPersistent) entity.persistentData.putBoolean('AEO_Battery', true);
      else entity.persistentData.putBoolean('AEO_Battery', false);
    }
  } catch (e) { }

  entity.server.runCommandSilent('scoreboard players set ' + username + ' code_position ' + parseInt(storedPosition));
  palladium.setProperty(entity, 'code', storedCode);

  var storedCurrentPlaylist = nbt.storedCurrentPlaylist || 1;
  var storedCurrentAlienSlot = nbt.storedCurrentAlienSlot || 1;
  entity.persistentData.putInt(CURRENT_PLAYLIST_KEY, storedCurrentPlaylist);
  entity.persistentData.putInt(CURRENT_ALIEN_SLOT_KEY, storedCurrentAlienSlot);

  function setScore(scoreName, scoreValue) {
    entity.server.runCommandSilent('scoreboard players set ' + username + ' ' + scoreName + ' ' + scoreValue);
  }
  function getStoredScore(nbtTag, defaultValue) {
    return nbt.contains(nbtTag) ? nbt.getInt(nbtTag) : defaultValue;
  }

  setScore('AlienEvo.10kPhase', getStoredScore('stored10kPhaseScore', 0));
  setScore('AlienEvo.10kStage', getStoredScore('stored10kStageScore', 0));
  setScore('AlienEvo.BasePrimary', getStoredScore('storedBasePrimaryScore', -1));
  setScore('AlienEvo.BaseSecondary', getStoredScore('storedBaseSecondaryScore', -1));
  setScore('AlienEvo.BaseTertiary', getStoredScore('storedBaseTertiaryScore', -1));
  setScore('AlienEvo.Buttons', getStoredScore('storedButtonsScore', -1));
  setScore('AlienEvo.CoreSide', getStoredScore('storedCoreSideScore', -1));
  setScore('AlienEvo.CoreTop', getStoredScore('storedCoreTopScore', -1));
  setScore('AlienEvo.DialInner', getStoredScore('storedDialInnerScore', -1));
  setScore('AlienEvo.DialOuter', getStoredScore('storedDialOuterScore', -1));
  setScore('AlienEvo.Tubes', getStoredScore('storedTubesScore', -1));
  setScore('AEO.Spikes', getStoredScore('storedSpikesScore', 0));
  setScore('AEO.Faceplate', getStoredScore('storedFaceplateScore', 0));
  setScore('AEO.AirBreather', getStoredScore('storedAeoAirBreatherScore', 0));
  setScore('AEO.Suit', getStoredScore('storedAeoSuitScore', 0));
  setScore('AEO.Battery', getStoredScore('storedAeoBatteryScore', 0));

  if (nbt.storedMastercontrol) entity.tags.add('AlienEvo.MasterControl');
  
  if (nbt.storedRandomizerUnlocked) entity.tags.add('AEO.RandomizerUnlocked');

  var wgPrefix = watchPrefix + '_glow_color_';
  if (typeof nbt.storedGlowColor1 === 'string') writeGlowHex(entity, 1, nbt.storedGlowColor1, wgPrefix);
  if (typeof nbt.storedGlowColor2 === 'string') writeGlowHex(entity, 2, nbt.storedGlowColor2, wgPrefix);
  if (typeof nbt.storedGlowColor3 === 'string') writeGlowHex(entity, 3, nbt.storedGlowColor3, wgPrefix);
  if (typeof nbt.storedGlowColor4 === 'string') writeGlowHex(entity, 4, nbt.storedGlowColor4, wgPrefix);
  if (typeof nbt.storedGlowColor5 === 'string') writeGlowHex(entity, 5, nbt.storedGlowColor5, wgPrefix);

  var ugPrefix = 'uniform_glow_color_';
  if (typeof nbt.storedGlowColorBase === 'string') writeGlowBase(entity, watchPrefix + '_glow_color_base', nbt.storedGlowColorBase);
  if (typeof nbt.storedUniformGlowColorBase === 'string') writeGlowBase(entity, 'uniform_glow_color_base', nbt.storedUniformGlowColorBase);

  
  if (typeof nbt.storedUniformGlowColor1 === 'string') writeGlowHex(entity, 1, nbt.storedUniformGlowColor1, ugPrefix);
  if (typeof nbt.storedUniformGlowColor2 === 'string') writeGlowHex(entity, 2, nbt.storedUniformGlowColor2, ugPrefix);
  if (typeof nbt.storedUniformGlowColor3 === 'string') writeGlowHex(entity, 3, nbt.storedUniformGlowColor3, ugPrefix);
  if (typeof nbt.storedUniformGlowColor4 === 'string') writeGlowHex(entity, 4, nbt.storedUniformGlowColor4, ugPrefix);
  if (typeof nbt.storedUniformGlowColor5 === 'string') writeGlowHex(entity, 5, nbt.storedUniformGlowColor5, ugPrefix);

  var utPrefix = getUniformColorPrefix(watchPrefix, 'tertiary');
  if (typeof nbt.storedUniformTertiaryColor1 === 'string') writeGlowHex(entity, 1, nbt.storedUniformTertiaryColor1, utPrefix);
  if (typeof nbt.storedUniformTertiaryColor2 === 'string') writeGlowHex(entity, 2, nbt.storedUniformTertiaryColor2, utPrefix);
  if (typeof nbt.storedUniformTertiaryColor3 === 'string') writeGlowHex(entity, 3, nbt.storedUniformTertiaryColor3, utPrefix);
  if (typeof nbt.storedUniformTertiaryColor4 === 'string') writeGlowHex(entity, 4, nbt.storedUniformTertiaryColor4, utPrefix);
  if (typeof nbt.storedUniformTertiaryColor5 === 'string') writeGlowHex(entity, 5, nbt.storedUniformTertiaryColor5, utPrefix);
  if (typeof nbt.storedUniformTertiaryColorBase === 'string') writeGlowBase(entity, getUniformColorBaseName(watchPrefix, 'tertiary'), nbt.storedUniformTertiaryColorBase);

  var upPrefix = getUniformColorPrefix(watchPrefix, 'primary');
  if (typeof nbt.storedUniformPrimaryColor1 === 'string') writeGlowHex(entity, 1, nbt.storedUniformPrimaryColor1, upPrefix);
  if (typeof nbt.storedUniformPrimaryColor2 === 'string') writeGlowHex(entity, 2, nbt.storedUniformPrimaryColor2, upPrefix);
  if (typeof nbt.storedUniformPrimaryColor3 === 'string') writeGlowHex(entity, 3, nbt.storedUniformPrimaryColor3, upPrefix);
  if (typeof nbt.storedUniformPrimaryColor4 === 'string') writeGlowHex(entity, 4, nbt.storedUniformPrimaryColor4, upPrefix);
  if (typeof nbt.storedUniformPrimaryColor5 === 'string') writeGlowHex(entity, 5, nbt.storedUniformPrimaryColor5, upPrefix);
  if (typeof nbt.storedUniformPrimaryColorBase === 'string') writeGlowBase(entity, getUniformColorBaseName(watchPrefix, 'primary'), nbt.storedUniformPrimaryColorBase);

  
  if (typeof nbt.storedGenericUniformPrimaryColor1 === 'string') writeGlowHex(entity, 1, nbt.storedGenericUniformPrimaryColor1, 'uniform_primary_color_');
  if (typeof nbt.storedGenericUniformPrimaryColor2 === 'string') writeGlowHex(entity, 2, nbt.storedGenericUniformPrimaryColor2, 'uniform_primary_color_');
  if (typeof nbt.storedGenericUniformPrimaryColor3 === 'string') writeGlowHex(entity, 3, nbt.storedGenericUniformPrimaryColor3, 'uniform_primary_color_');
  if (typeof nbt.storedGenericUniformPrimaryColor4 === 'string') writeGlowHex(entity, 4, nbt.storedGenericUniformPrimaryColor4, 'uniform_primary_color_');
  if (typeof nbt.storedGenericUniformPrimaryColor5 === 'string') writeGlowHex(entity, 5, nbt.storedGenericUniformPrimaryColor5, 'uniform_primary_color_');
  if (typeof nbt.storedGenericUniformPrimaryColorBase === 'string') writeGlowBase(entity, 'uniform_primary_color_base', nbt.storedGenericUniformPrimaryColorBase);

  var usPrefix = getUniformColorPrefix(watchPrefix, 'secondary');
  if (typeof nbt.storedUniformSecondaryColor1 === 'string') writeGlowHex(entity, 1, nbt.storedUniformSecondaryColor1, usPrefix);
  if (typeof nbt.storedUniformSecondaryColor2 === 'string') writeGlowHex(entity, 2, nbt.storedUniformSecondaryColor2, usPrefix);
  if (typeof nbt.storedUniformSecondaryColor3 === 'string') writeGlowHex(entity, 3, nbt.storedUniformSecondaryColor3, usPrefix);
  if (typeof nbt.storedUniformSecondaryColor4 === 'string') writeGlowHex(entity, 4, nbt.storedUniformSecondaryColor4, usPrefix);
  if (typeof nbt.storedUniformSecondaryColor5 === 'string') writeGlowHex(entity, 5, nbt.storedUniformSecondaryColor5, usPrefix);
  if (typeof nbt.storedUniformSecondaryColorBase === 'string') writeGlowBase(entity, getUniformColorBaseName(watchPrefix, 'secondary'), nbt.storedUniformSecondaryColorBase);

  
  if (typeof nbt.storedGenericUniformSecondaryColor1 === 'string') writeGlowHex(entity, 1, nbt.storedGenericUniformSecondaryColor1, 'uniform_secondary_color_');
  if (typeof nbt.storedGenericUniformSecondaryColor2 === 'string') writeGlowHex(entity, 2, nbt.storedGenericUniformSecondaryColor2, 'uniform_secondary_color_');
  if (typeof nbt.storedGenericUniformSecondaryColor3 === 'string') writeGlowHex(entity, 3, nbt.storedGenericUniformSecondaryColor3, 'uniform_secondary_color_');
  if (typeof nbt.storedGenericUniformSecondaryColor4 === 'string') writeGlowHex(entity, 4, nbt.storedGenericUniformSecondaryColor4, 'uniform_secondary_color_');
  if (typeof nbt.storedGenericUniformSecondaryColor5 === 'string') writeGlowHex(entity, 5, nbt.storedGenericUniformSecondaryColor5, 'uniform_secondary_color_');
  if (typeof nbt.storedGenericUniformSecondaryColorBase === 'string') writeGlowBase(entity, 'uniform_secondary_color_base', nbt.storedGenericUniformSecondaryColorBase);

  if (typeof nbt.storedAlienGlowProps === 'string' && nbt.storedAlienGlowProps.length) {
    try {
      var parsedAlienGlow = JSON.parse(nbt.storedAlienGlowProps);
      restoreGeneratedAlienGlowProps(entity, parsedAlienGlow);
    } catch (eAG) {
      console.log('Failed to parse storedAlienGlowProps:', eAG);
    }
  }


  updateAllSlotProperties(entity, storedCurrentPlaylist);

  entity.setMainHandItem(Item.of('minecraft:air'));
}

function giveFirstTwentySplit(entity) {
  
  var ids = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 31, 32, 33, 34, 35, 36, 80];

  
  ids = ids.filter(function (v) { return Number.isInteger(v) && v > 0; });
  ids = Array.from(new Set(ids));

  
  function shuffle(arr) {
    var a = arr.slice();
    for (var i = a.length - 1; i > 0; i--) {
      var j = Math.floor(Math.random() * (i + 1));
      var tmp = a[i]; a[i] = a[j]; a[j] = tmp;
    }
    return a;
  }

  
  var pool = shuffle(ids.slice());
  while (pool.length < 20) pool.push(0);
  pool = pool.slice(0, 20);

  console.log('[giveFirstTwentySplit] final hardcoded pool (20):', pool);

  
  for (var slot = 1; slot <= 10; slot++) {
    var alienKey1 = 'alienevo.alien_1_' + slot;
    var alienId1 = pool[slot - 1] || 0;
    entity.persistentData.putInt(alienKey1, alienId1);
  }
  for (var slot2 = 1; slot2 <= 10; slot2++) {
    var alienKey2 = 'alienevo.alien_2_' + slot2;
    var alienId2 = pool[10 + (slot2 - 1)] || 0;
    entity.persistentData.putInt(alienKey2, alienId2);
  }

  
  if (SLOTS_PER_PLAYLIST > 10) {
    for (var s = 11; s <= SLOTS_PER_PLAYLIST; s++) {
      entity.persistentData.putInt('alienevo.alien_1_' + s, 0);
      entity.persistentData.putInt('alienevo.alien_2_' + s, 0);
    }
  }

  
  for (var p = 3; p <= MAX_PLAYLISTS; p++) {
    for (var s2 = 1; s2 <= SLOTS_PER_PLAYLIST; s2++) {
      entity.persistentData.putInt('alienevo.alien_' + p + '_' + s2, 0);
    }
  }

  entity.persistentData.putInt(CURRENT_PLAYLIST_KEY, 1);
  entity.persistentData.putInt(CURRENT_ALIEN_SLOT_KEY, 1);

  updateAllSlotProperties(entity, 1);
  updateAllSlotProperties(entity, 2);
}

StartupEvents.registry('palladium:abilities', function (event) {
  event.create('aeo:decouple_omniverse')
    .icon(palladium.createItemIcon('alienevo:omniverse_omnitrix'))
    .addProperty('property', 'string', 'alienevodnaomnitrixgeneration_omniverse', '')
    .tick(function (entity, entry, holder, enabled) {
      if (enabled) {
        palladium.setProperty(entity, 'watch', 'omniverse');
        createAndGiveOmnitrix(entity);
      }
    });

  event.create('aeo:couple_omniverse')
    .icon(palladium.createItemIcon('alienevo:omniverse_omnitrix'))
    .addProperty('property', 'string', 'alienevodnaomnitrixapplication_omniverse', '')
    .tick(function (entity, entry, holder, enabled) {
      if (enabled) {
        palladium.setProperty(entity, 'watch', 'omniverse');
        applyAllDNAFromOmnitrix(entity);
      }
    });
});

